/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.InAppCampaignSchedule;
import software.amazon.awssdk.services.pinpoint.model.InAppMessage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InAppMessageCampaign
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InAppMessageCampaign> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignId").getter(InAppMessageCampaign.getter(InAppMessageCampaign::campaignId)).setter(InAppMessageCampaign.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()}).build();
    private static final SdkField<Integer> DAILY_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DailyCap").getter(InAppMessageCampaign.getter(InAppMessageCampaign::dailyCap)).setter(InAppMessageCampaign.setter(Builder::dailyCap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyCap").build()}).build();
    private static final SdkField<InAppMessage> IN_APP_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InAppMessage").getter(InAppMessageCampaign.getter(InAppMessageCampaign::inAppMessage)).setter(InAppMessageCampaign.setter(Builder::inAppMessage)).constructor(InAppMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppMessage").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(InAppMessageCampaign.getter(InAppMessageCampaign::priority)).setter(InAppMessageCampaign.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<InAppCampaignSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(InAppMessageCampaign.getter(InAppMessageCampaign::schedule)).setter(InAppMessageCampaign.setter(Builder::schedule)).constructor(InAppCampaignSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<Integer> SESSION_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionCap").getter(InAppMessageCampaign.getter(InAppMessageCampaign::sessionCap)).setter(InAppMessageCampaign.setter(Builder::sessionCap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionCap").build()}).build();
    private static final SdkField<Integer> TOTAL_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCap").getter(InAppMessageCampaign.getter(InAppMessageCampaign::totalCap)).setter(InAppMessageCampaign.setter(Builder::totalCap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCap").build()}).build();
    private static final SdkField<String> TREATMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentId").getter(InAppMessageCampaign.getter(InAppMessageCampaign::treatmentId)).setter(InAppMessageCampaign.setter(Builder::treatmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD, DAILY_CAP_FIELD, IN_APP_MESSAGE_FIELD, PRIORITY_FIELD, SCHEDULE_FIELD, SESSION_CAP_FIELD, TOTAL_CAP_FIELD, TREATMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InAppMessageCampaign.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String campaignId;
    private final Integer dailyCap;
    private final InAppMessage inAppMessage;
    private final Integer priority;
    private final InAppCampaignSchedule schedule;
    private final Integer sessionCap;
    private final Integer totalCap;
    private final String treatmentId;

    private InAppMessageCampaign(BuilderImpl builder) {
        this.campaignId = builder.campaignId;
        this.dailyCap = builder.dailyCap;
        this.inAppMessage = builder.inAppMessage;
        this.priority = builder.priority;
        this.schedule = builder.schedule;
        this.sessionCap = builder.sessionCap;
        this.totalCap = builder.totalCap;
        this.treatmentId = builder.treatmentId;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final Integer dailyCap() {
        return this.dailyCap;
    }

    public final InAppMessage inAppMessage() {
        return this.inAppMessage;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final InAppCampaignSchedule schedule() {
        return this.schedule;
    }

    public final Integer sessionCap() {
        return this.sessionCap;
    }

    public final Integer totalCap() {
        return this.totalCap;
    }

    public final String treatmentId() {
        return this.treatmentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyCap());
        hashCode = 31 * hashCode + Objects.hashCode(this.inAppMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionCap());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCap());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageCampaign)) {
            return false;
        }
        InAppMessageCampaign other = (InAppMessageCampaign)obj;
        return Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.dailyCap(), other.dailyCap()) && Objects.equals(this.inAppMessage(), other.inAppMessage()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.sessionCap(), other.sessionCap()) && Objects.equals(this.totalCap(), other.totalCap()) && Objects.equals(this.treatmentId(), other.treatmentId());
    }

    public final String toString() {
        return ToString.builder((String)"InAppMessageCampaign").add("CampaignId", (Object)this.campaignId()).add("DailyCap", (Object)this.dailyCap()).add("InAppMessage", (Object)this.inAppMessage()).add("Priority", (Object)this.priority()).add("Schedule", (Object)this.schedule()).add("SessionCap", (Object)this.sessionCap()).add("TotalCap", (Object)this.totalCap()).add("TreatmentId", (Object)this.treatmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CampaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "DailyCap": {
                return Optional.ofNullable(clazz.cast(this.dailyCap()));
            }
            case "InAppMessage": {
                return Optional.ofNullable(clazz.cast(this.inAppMessage()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "SessionCap": {
                return Optional.ofNullable(clazz.cast(this.sessionCap()));
            }
            case "TotalCap": {
                return Optional.ofNullable(clazz.cast(this.totalCap()));
            }
            case "TreatmentId": {
                return Optional.ofNullable(clazz.cast(this.treatmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CampaignId", CAMPAIGN_ID_FIELD);
        map.put("DailyCap", DAILY_CAP_FIELD);
        map.put("InAppMessage", IN_APP_MESSAGE_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("SessionCap", SESSION_CAP_FIELD);
        map.put("TotalCap", TOTAL_CAP_FIELD);
        map.put("TreatmentId", TREATMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageCampaign, T> g) {
        return obj -> g.apply((InAppMessageCampaign)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String campaignId;
        private Integer dailyCap;
        private InAppMessage inAppMessage;
        private Integer priority;
        private InAppCampaignSchedule schedule;
        private Integer sessionCap;
        private Integer totalCap;
        private String treatmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageCampaign model) {
            this.campaignId(model.campaignId);
            this.dailyCap(model.dailyCap);
            this.inAppMessage(model.inAppMessage);
            this.priority(model.priority);
            this.schedule(model.schedule);
            this.sessionCap(model.sessionCap);
            this.totalCap(model.totalCap);
            this.treatmentId(model.treatmentId);
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final Integer getDailyCap() {
            return this.dailyCap;
        }

        public final void setDailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
        }

        @Override
        public final Builder dailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
            return this;
        }

        public final InAppMessage.Builder getInAppMessage() {
            return this.inAppMessage != null ? this.inAppMessage.toBuilder() : null;
        }

        public final void setInAppMessage(InAppMessage.BuilderImpl inAppMessage) {
            this.inAppMessage = inAppMessage != null ? inAppMessage.build() : null;
        }

        @Override
        public final Builder inAppMessage(InAppMessage inAppMessage) {
            this.inAppMessage = inAppMessage;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final InAppCampaignSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(InAppCampaignSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InAppCampaignSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Integer getSessionCap() {
            return this.sessionCap;
        }

        public final void setSessionCap(Integer sessionCap) {
            this.sessionCap = sessionCap;
        }

        @Override
        public final Builder sessionCap(Integer sessionCap) {
            this.sessionCap = sessionCap;
            return this;
        }

        public final Integer getTotalCap() {
            return this.totalCap;
        }

        public final void setTotalCap(Integer totalCap) {
            this.totalCap = totalCap;
        }

        @Override
        public final Builder totalCap(Integer totalCap) {
            this.totalCap = totalCap;
            return this;
        }

        public final String getTreatmentId() {
            return this.treatmentId;
        }

        public final void setTreatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
        }

        @Override
        public final Builder treatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
            return this;
        }

        public InAppMessageCampaign build() {
            return new InAppMessageCampaign(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InAppMessageCampaign> {
        public Builder campaignId(String var1);

        public Builder dailyCap(Integer var1);

        public Builder inAppMessage(InAppMessage var1);

        default public Builder inAppMessage(Consumer<InAppMessage.Builder> inAppMessage) {
            return this.inAppMessage((InAppMessage)((InAppMessage.Builder)InAppMessage.builder().applyMutation(inAppMessage)).build());
        }

        public Builder priority(Integer var1);

        public Builder schedule(InAppCampaignSchedule var1);

        default public Builder schedule(Consumer<InAppCampaignSchedule.Builder> schedule) {
            return this.schedule((InAppCampaignSchedule)((InAppCampaignSchedule.Builder)InAppCampaignSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder sessionCap(Integer var1);

        public Builder totalCap(Integer var1);

        public Builder treatmentId(String var1);
    }
}

