/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ListOfMessageHeaderCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageHeader;
import software.amazon.awssdk.services.pinpoint.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailTemplateResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(EmailTemplateResponse.getter(EmailTemplateResponse::arn)).setter(EmailTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(EmailTemplateResponse.getter(EmailTemplateResponse::creationDate)).setter(EmailTemplateResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSubstitutions").getter(EmailTemplateResponse.getter(EmailTemplateResponse::defaultSubstitutions)).setter(EmailTemplateResponse.setter(Builder::defaultSubstitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build()}).build();
    private static final SdkField<String> HTML_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HtmlPart").getter(EmailTemplateResponse.getter(EmailTemplateResponse::htmlPart)).setter(EmailTemplateResponse.setter(Builder::htmlPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(EmailTemplateResponse.getter(EmailTemplateResponse::lastModifiedDate)).setter(EmailTemplateResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderId").getter(EmailTemplateResponse.getter(EmailTemplateResponse::recommenderId)).setter(EmailTemplateResponse.setter(Builder::recommenderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(EmailTemplateResponse.getter(EmailTemplateResponse::subject)).setter(EmailTemplateResponse.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Headers").getter(EmailTemplateResponse.getter(EmailTemplateResponse::headers)).setter(EmailTemplateResponse.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(EmailTemplateResponse.getter(EmailTemplateResponse::tags)).setter(EmailTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateDescription").getter(EmailTemplateResponse.getter(EmailTemplateResponse::templateDescription)).setter(EmailTemplateResponse.setter(Builder::templateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(EmailTemplateResponse.getter(EmailTemplateResponse::templateName)).setter(EmailTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(EmailTemplateResponse.getter(EmailTemplateResponse::templateTypeAsString)).setter(EmailTemplateResponse.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final SdkField<String> TEXT_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextPart").getter(EmailTemplateResponse.getter(EmailTemplateResponse::textPart)).setter(EmailTemplateResponse.setter(Builder::textPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(EmailTemplateResponse.getter(EmailTemplateResponse::version)).setter(EmailTemplateResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_DATE_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, HTML_PART_FIELD, LAST_MODIFIED_DATE_FIELD, RECOMMENDER_ID_FIELD, SUBJECT_FIELD, HEADERS_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD, TEXT_PART_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String creationDate;
    private final String defaultSubstitutions;
    private final String htmlPart;
    private final String lastModifiedDate;
    private final String recommenderId;
    private final String subject;
    private final List<MessageHeader> headers;
    private final Map<String, String> tags;
    private final String templateDescription;
    private final String templateName;
    private final String templateType;
    private final String textPart;
    private final String version;

    private EmailTemplateResponse(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.htmlPart = builder.htmlPart;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.recommenderId = builder.recommenderId;
        this.subject = builder.subject;
        this.headers = builder.headers;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.textPart = builder.textPart;
        this.version = builder.version;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String defaultSubstitutions() {
        return this.defaultSubstitutions;
    }

    public final String htmlPart() {
        return this.htmlPart;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String recommenderId() {
        return this.recommenderId;
    }

    public final String subject() {
        return this.subject;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<MessageHeader> headers() {
        return this.headers;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String templateDescription() {
        return this.templateDescription;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public final String textPart() {
        return this.textPart;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.textPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateResponse)) {
            return false;
        }
        EmailTemplateResponse other = (EmailTemplateResponse)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(this.htmlPart(), other.htmlPart()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.recommenderId(), other.recommenderId()) && Objects.equals(this.subject(), other.subject()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateDescription(), other.templateDescription()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString()) && Objects.equals(this.textPart(), other.textPart()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"EmailTemplateResponse").add("Arn", (Object)this.arn()).add("CreationDate", (Object)this.creationDate()).add("DefaultSubstitutions", (Object)this.defaultSubstitutions()).add("HtmlPart", (Object)this.htmlPart()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("RecommenderId", (Object)this.recommenderId()).add("Subject", (Object)this.subject()).add("Headers", this.hasHeaders() ? this.headers() : null).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateDescription", (Object)this.templateDescription()).add("TemplateName", (Object)this.templateName()).add("TemplateType", (Object)this.templateTypeAsString()).add("TextPart", (Object)this.textPart()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "DefaultSubstitutions": {
                return Optional.ofNullable(clazz.cast(this.defaultSubstitutions()));
            }
            case "HtmlPart": {
                return Optional.ofNullable(clazz.cast(this.htmlPart()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "RecommenderId": {
                return Optional.ofNullable(clazz.cast(this.recommenderId()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateDescription": {
                return Optional.ofNullable(clazz.cast(this.templateDescription()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
            case "TextPart": {
                return Optional.ofNullable(clazz.cast(this.textPart()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailTemplateResponse, T> g) {
        return obj -> g.apply((EmailTemplateResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String creationDate;
        private String defaultSubstitutions;
        private String htmlPart;
        private String lastModifiedDate;
        private String recommenderId;
        private String subject;
        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateDescription;
        private String templateName;
        private String templateType;
        private String textPart;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailTemplateResponse model) {
            this.arn(model.arn);
            this.creationDate(model.creationDate);
            this.defaultSubstitutions(model.defaultSubstitutions);
            this.htmlPart(model.htmlPart);
            this.lastModifiedDate(model.lastModifiedDate);
            this.recommenderId(model.recommenderId);
            this.subject(model.subject);
            this.headers(model.headers);
            this.tags(model.tags);
            this.templateDescription(model.templateDescription);
            this.templateName(model.templateName);
            this.templateType(model.templateType);
            this.textPart(model.textPart);
            this.version(model.version);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final String getHtmlPart() {
            return this.htmlPart;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getRecommenderId() {
            return this.recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = ListOfMessageHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = ListOfMessageHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = ListOfMessageHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (MessageHeader)((MessageHeader.Builder)MessageHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getTextPart() {
            return this.textPart;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public EmailTemplateResponse build() {
            return new EmailTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailTemplateResponse> {
        public Builder arn(String var1);

        public Builder creationDate(String var1);

        public Builder defaultSubstitutions(String var1);

        public Builder htmlPart(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder recommenderId(String var1);

        public Builder subject(String var1);

        public Builder headers(Collection<MessageHeader> var1);

        public Builder headers(MessageHeader ... var1);

        public Builder headers(Consumer<MessageHeader.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateDescription(String var1);

        public Builder templateName(String var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);

        public Builder textPart(String var1);

        public Builder version(String var1);
    }
}

