/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pinpoint.DefaultPinpointAsyncClient;
import software.amazon.awssdk.services.pinpoint.DefaultPinpointBaseClientBuilder;
import software.amazon.awssdk.services.pinpoint.PinpointAsyncClient;
import software.amazon.awssdk.services.pinpoint.PinpointAsyncClientBuilder;
import software.amazon.awssdk.services.pinpoint.PinpointServiceClientConfiguration;
import software.amazon.awssdk.services.pinpoint.endpoints.PinpointEndpointProvider;

@SdkInternalApi
final class DefaultPinpointAsyncClientBuilder
extends DefaultPinpointBaseClientBuilder<PinpointAsyncClientBuilder, PinpointAsyncClient>
implements PinpointAsyncClientBuilder {
    DefaultPinpointAsyncClientBuilder() {
    }

    @Override
    public DefaultPinpointAsyncClientBuilder endpointProvider(PinpointEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PinpointAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPinpointAsyncClientBuilder.validateClientOptions(clientConfiguration);
        PinpointServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPinpointAsyncClient client = new DefaultPinpointAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PinpointServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PinpointServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

