/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSegmentRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateSegmentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateSegmentRequest.getter(UpdateSegmentRequest::applicationId)).setter(UpdateSegmentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentId").getter(UpdateSegmentRequest.getter(UpdateSegmentRequest::segmentId)).setter(UpdateSegmentRequest.setter(Builder::segmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("segment-id").build()}).build();
    private static final SdkField<WriteSegmentRequest> WRITE_SEGMENT_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WriteSegmentRequest").getter(UpdateSegmentRequest.getter(UpdateSegmentRequest::writeSegmentRequest)).setter(UpdateSegmentRequest.setter(Builder::writeSegmentRequest)).constructor(WriteSegmentRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteSegmentRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, SEGMENT_ID_FIELD, WRITE_SEGMENT_REQUEST_FIELD));
    private final String applicationId;
    private final String segmentId;
    private final WriteSegmentRequest writeSegmentRequest;

    private UpdateSegmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.segmentId = builder.segmentId;
        this.writeSegmentRequest = builder.writeSegmentRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String segmentId() {
        return this.segmentId;
    }

    public final WriteSegmentRequest writeSegmentRequest() {
        return this.writeSegmentRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeSegmentRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSegmentRequest)) {
            return false;
        }
        UpdateSegmentRequest other = (UpdateSegmentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.writeSegmentRequest(), other.writeSegmentRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSegmentRequest").add("ApplicationId", (Object)this.applicationId()).add("SegmentId", (Object)this.segmentId()).add("WriteSegmentRequest", (Object)this.writeSegmentRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "WriteSegmentRequest": {
                return Optional.ofNullable(clazz.cast(this.writeSegmentRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSegmentRequest, T> g) {
        return obj -> g.apply((UpdateSegmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String segmentId;
        private WriteSegmentRequest writeSegmentRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSegmentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.segmentId(model.segmentId);
            this.writeSegmentRequest(model.writeSegmentRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final WriteSegmentRequest.Builder getWriteSegmentRequest() {
            return this.writeSegmentRequest != null ? this.writeSegmentRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeSegmentRequest(WriteSegmentRequest writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest;
            return this;
        }

        public final void setWriteSegmentRequest(WriteSegmentRequest.BuilderImpl writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest != null ? writeSegmentRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSegmentRequest build() {
            return new UpdateSegmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSegmentRequest> {
        public Builder applicationId(String var1);

        public Builder segmentId(String var1);

        public Builder writeSegmentRequest(WriteSegmentRequest var1);

        default public Builder writeSegmentRequest(Consumer<WriteSegmentRequest.Builder> writeSegmentRequest) {
            return this.writeSegmentRequest((WriteSegmentRequest)((WriteSegmentRequest.Builder)WriteSegmentRequest.builder().applyMutation(writeSegmentRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

