/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum State {
    DRAFT("DRAFT"),
    ACTIVE("ACTIVE"),
    COMPLETED("COMPLETED"),
    CANCELLED("CANCELLED"),
    CLOSED("CLOSED"),
    PAUSED("PAUSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private State(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static State fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(State.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<State> knownValues() {
        return Stream.of(State.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

