/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3)
 * bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportJobRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportJobRequest.Builder, ExportJobRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ExportJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> S3_URL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3UrlPrefix").getter(getter(ExportJobRequest::s3UrlPrefix)).setter(setter(Builder::s3UrlPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UrlPrefix").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentId").getter(getter(ExportJobRequest::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentVersion").getter(getter(ExportJobRequest::segmentVersion))
            .setter(setter(Builder::segmentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            S3_URL_PREFIX_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String s3UrlPrefix;

    private final String segmentId;

    private final Integer segmentVersion;

    private ExportJobRequest(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.s3UrlPrefix = builder.s3UrlPrefix;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
     * Pinpoint to access the Amazon S3 location where you want to export endpoint definitions to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
     *         Amazon Pinpoint to access the Amazon S3 location where you want to export endpoint definitions to.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where you want to export endpoint
     * definitions to. This location is typically a folder that contains multiple files. The URL should be in the
     * following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
     * </p>
     * 
     * @return The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where you want to export
     *         endpoint definitions to. This location is typically a folder that contains multiple files. The URL should
     *         be in the following format:
     *         s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
     */
    public final String s3UrlPrefix() {
        return s3UrlPrefix;
    }

    /**
     * <p>
     * The identifier for the segment to export endpoint definitions from. If you don't specify this value, Amazon
     * Pinpoint exports definitions for all the endpoints that are associated with the application.
     * </p>
     * 
     * @return The identifier for the segment to export endpoint definitions from. If you don't specify this value,
     *         Amazon Pinpoint exports definitions for all the endpoints that are associated with the application.
     */
    public final String segmentId() {
        return segmentId;
    }

    /**
     * <p>
     * The version of the segment to export endpoint definitions from, if specified.
     * </p>
     * 
     * @return The version of the segment to export endpoint definitions from, if specified.
     */
    public final Integer segmentVersion() {
        return segmentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3UrlPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobRequest)) {
            return false;
        }
        ExportJobRequest other = (ExportJobRequest) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(s3UrlPrefix(), other.s3UrlPrefix())
                && Objects.equals(segmentId(), other.segmentId()) && Objects.equals(segmentVersion(), other.segmentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportJobRequest").add("RoleArn", roleArn()).add("S3UrlPrefix", s3UrlPrefix())
                .add("SegmentId", segmentId()).add("SegmentVersion", segmentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "S3UrlPrefix":
            return Optional.ofNullable(clazz.cast(s3UrlPrefix()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentVersion":
            return Optional.ofNullable(clazz.cast(segmentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportJobRequest, T> g) {
        return obj -> g.apply((ExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportJobRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
         * Pinpoint to access the Amazon S3 location where you want to export endpoint definitions to.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
         *        Amazon Pinpoint to access the Amazon S3 location where you want to export endpoint definitions to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where you want to export
         * endpoint definitions to. This location is typically a folder that contains multiple files. The URL should be
         * in the following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
         * </p>
         * 
         * @param s3UrlPrefix
         *        The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where you want to
         *        export endpoint definitions to. This location is typically a folder that contains multiple files. The
         *        URL should be in the following format:
         *        s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3UrlPrefix(String s3UrlPrefix);

        /**
         * <p>
         * The identifier for the segment to export endpoint definitions from. If you don't specify this value, Amazon
         * Pinpoint exports definitions for all the endpoints that are associated with the application.
         * </p>
         * 
         * @param segmentId
         *        The identifier for the segment to export endpoint definitions from. If you don't specify this value,
         *        Amazon Pinpoint exports definitions for all the endpoints that are associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * <p>
         * The version of the segment to export endpoint definitions from, if specified.
         * </p>
         * 
         * @param segmentVersion
         *        The version of the segment to export endpoint definitions from, if specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentVersion(Integer segmentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String s3UrlPrefix;

        private String segmentId;

        private Integer segmentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobRequest model) {
            roleArn(model.roleArn);
            s3UrlPrefix(model.s3UrlPrefix);
            segmentId(model.segmentId);
            segmentVersion(model.segmentVersion);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3UrlPrefix() {
            return s3UrlPrefix;
        }

        @Override
        public final Builder s3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
            return this;
        }

        public final void setS3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        @Override
        public ExportJobRequest build() {
            return new ExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
