/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies geographic information about an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointLocation.Builder, EndpointLocation> {
    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(EndpointLocation::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(EndpointLocation::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<Double> LATITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Latitude").getter(getter(EndpointLocation::latitude)).setter(setter(Builder::latitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latitude").build()).build();

    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Longitude").getter(getter(EndpointLocation::longitude)).setter(setter(Builder::longitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Longitude").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(EndpointLocation::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(EndpointLocation::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_FIELD,
            LATITUDE_FIELD, LONGITUDE_FIELD, POSTAL_CODE_FIELD, REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String city;

    private final String country;

    private final Double latitude;

    private final Double longitude;

    private final String postalCode;

    private final String region;

    private EndpointLocation(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
    }

    /**
     * <p>
     * The name of the city where the endpoint is located.
     * </p>
     * 
     * @return The name of the city where the endpoint is located.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is located.
     * For example, US for the United States.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is
     *         located. For example, US for the United States.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The latitude coordinate of the endpoint location, rounded to one decimal place.
     * </p>
     * 
     * @return The latitude coordinate of the endpoint location, rounded to one decimal place.
     */
    public final Double latitude() {
        return latitude;
    }

    /**
     * <p>
     * The longitude coordinate of the endpoint location, rounded to one decimal place.
     * </p>
     * 
     * @return The longitude coordinate of the endpoint location, rounded to one decimal place.
     */
    public final Double longitude() {
        return longitude;
    }

    /**
     * <p>
     * The postal or ZIP code for the area where the endpoint is located.
     * </p>
     * 
     * @return The postal or ZIP code for the area where the endpoint is located.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The name of the region where the endpoint is located. For locations in the United States, this value is the name
     * of a state.
     * </p>
     * 
     * @return The name of the region where the endpoint is located. For locations in the United States, this value is
     *         the name of a state.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointLocation)) {
            return false;
        }
        EndpointLocation other = (EndpointLocation) obj;
        return Objects.equals(city(), other.city()) && Objects.equals(country(), other.country())
                && Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointLocation").add("City", city()).add("Country", country()).add("Latitude", latitude())
                .add("Longitude", longitude()).add("PostalCode", postalCode()).add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Latitude":
            return Optional.ofNullable(clazz.cast(latitude()));
        case "Longitude":
            return Optional.ofNullable(clazz.cast(longitude()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointLocation, T> g) {
        return obj -> g.apply((EndpointLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointLocation> {
        /**
         * <p>
         * The name of the city where the endpoint is located.
         * </p>
         * 
         * @param city
         *        The name of the city where the endpoint is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is
         * located. For example, US for the United States.
         * </p>
         * 
         * @param country
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is
         *        located. For example, US for the United States.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The latitude coordinate of the endpoint location, rounded to one decimal place.
         * </p>
         * 
         * @param latitude
         *        The latitude coordinate of the endpoint location, rounded to one decimal place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(Double latitude);

        /**
         * <p>
         * The longitude coordinate of the endpoint location, rounded to one decimal place.
         * </p>
         * 
         * @param longitude
         *        The longitude coordinate of the endpoint location, rounded to one decimal place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(Double longitude);

        /**
         * <p>
         * The postal or ZIP code for the area where the endpoint is located.
         * </p>
         * 
         * @param postalCode
         *        The postal or ZIP code for the area where the endpoint is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The name of the region where the endpoint is located. For locations in the United States, this value is the
         * name of a state.
         * </p>
         * 
         * @param region
         *        The name of the region where the endpoint is located. For locations in the United States, this value
         *        is the name of a state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String city;

        private String country;

        private Double latitude;

        private Double longitude;

        private String postalCode;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointLocation model) {
            city(model.city);
            country(model.country);
            latitude(model.latitude);
            longitude(model.longitude);
            postalCode(model.postalCode);
            region(model.region);
        }

        public final String getCity() {
            return city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getCountry() {
            return country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final Double getLatitude() {
            return latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public EndpointLocation build() {
            return new EndpointLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
