/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends PinpointRequest implements
        ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<CreateApplicationRequest> CREATE_APPLICATION_REQUEST_FIELD = SdkField
            .<CreateApplicationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("CreateApplicationRequest")
            .getter(getter(CreateAppRequest::createApplicationRequest))
            .setter(setter(Builder::createApplicationRequest))
            .constructor(CreateApplicationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateApplicationRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATE_APPLICATION_REQUEST_FIELD));

    private final CreateApplicationRequest createApplicationRequest;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.createApplicationRequest = builder.createApplicationRequest;
    }

    /**
     * Returns the value of the CreateApplicationRequest property for this object.
     * 
     * @return The value of the CreateApplicationRequest property for this object.
     */
    public final CreateApplicationRequest createApplicationRequest() {
        return createApplicationRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createApplicationRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(createApplicationRequest(), other.createApplicationRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppRequest").add("CreateApplicationRequest", createApplicationRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateApplicationRequest":
            return Optional.ofNullable(clazz.cast(createApplicationRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * Sets the value of the CreateApplicationRequest property for this object.
         *
         * @param createApplicationRequest
         *        The new value for the CreateApplicationRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createApplicationRequest(CreateApplicationRequest createApplicationRequest);

        /**
         * Sets the value of the CreateApplicationRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the
         * need to create one manually via {@link CreateApplicationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateApplicationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #createApplicationRequest(CreateApplicationRequest)}.
         * 
         * @param createApplicationRequest
         *        a consumer that will call methods on {@link CreateApplicationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createApplicationRequest(CreateApplicationRequest)
         */
        default Builder createApplicationRequest(Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
            return createApplicationRequest(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private CreateApplicationRequest createApplicationRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            createApplicationRequest(model.createApplicationRequest);
        }

        public final CreateApplicationRequest.Builder getCreateApplicationRequest() {
            return createApplicationRequest != null ? createApplicationRequest.toBuilder() : null;
        }

        @Override
        public final Builder createApplicationRequest(CreateApplicationRequest createApplicationRequest) {
            this.createApplicationRequest = createApplicationRequest;
            return this;
        }

        public final void setCreateApplicationRequest(CreateApplicationRequest.BuilderImpl createApplicationRequest) {
            this.createApplicationRequest = createApplicationRequest != null ? createApplicationRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
