/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content and settings for an SMS message that's sent to recipients of a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignSmsMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignSmsMessage.Builder, CampaignSmsMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(CampaignSmsMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(CampaignSmsMessage::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<String> ORIGINATION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationNumber").getter(getter(CampaignSmsMessage::originationNumber))
            .setter(setter(Builder::originationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationNumber").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderId").getter(getter(CampaignSmsMessage::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            MESSAGE_TYPE_FIELD, ORIGINATION_NUMBER_FIELD, SENDER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String messageType;

    private final String originationNumber;

    private final String senderId;

    private CampaignSmsMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.messageType = builder.messageType;
        this.originationNumber = builder.originationNumber;
        this.senderId = builder.senderId;
    }

    /**
     * <p>
     * The body of the SMS message.
     * </p>
     * 
     * @return The body of the SMS message.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a
     * one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing
     * messages).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive,
     *         such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such
     *         as marketing messages).
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a
     * one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing
     * messages).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive,
     *         such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such
     *         as marketing messages).
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned
     * to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164
     * format to ensure prompt and accurate delivery of the message. For example, +12065550100.
     * </p>
     * 
     * @return The long code to send the SMS message from. This value should be one of the dedicated long codes that's
     *         assigned to your AWS account. Although it isn't required, we recommend that you specify the long code
     *         using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.
     */
    public final String originationNumber() {
        return originationNumber;
    }

    /**
     * <p>
     * The sender ID to display on recipients' devices when they receive the SMS message.
     * </p>
     * 
     * @return The sender ID to display on recipients' devices when they receive the SMS message.
     */
    public final String senderId() {
        return senderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSmsMessage)) {
            return false;
        }
        CampaignSmsMessage other = (CampaignSmsMessage) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(originationNumber(), other.originationNumber()) && Objects.equals(senderId(), other.senderId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignSmsMessage").add("Body", body()).add("MessageType", messageTypeAsString())
                .add("OriginationNumber", originationNumber()).add("SenderId", senderId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "OriginationNumber":
            return Optional.ofNullable(clazz.cast(originationNumber()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignSmsMessage, T> g) {
        return obj -> g.apply((CampaignSmsMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignSmsMessage> {
        /**
         * <p>
         * The body of the SMS message.
         * </p>
         * 
         * @param body
         *        The body of the SMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such
         * as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as
         * marketing messages).
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or
         *        time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or
         *        time-sensitive, such as marketing messages).
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such
         * as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as
         * marketing messages).
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or
         *        time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or
         *        time-sensitive, such as marketing messages).
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * The long code to send the SMS message from. This value should be one of the dedicated long codes that's
         * assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using
         * an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.
         * </p>
         * 
         * @param originationNumber
         *        The long code to send the SMS message from. This value should be one of the dedicated long codes
         *        that's assigned to your AWS account. Although it isn't required, we recommend that you specify the
         *        long code using an E.164 format to ensure prompt and accurate delivery of the message. For example,
         *        +12065550100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationNumber(String originationNumber);

        /**
         * <p>
         * The sender ID to display on recipients' devices when they receive the SMS message.
         * </p>
         * 
         * @param senderId
         *        The sender ID to display on recipients' devices when they receive the SMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String messageType;

        private String originationNumber;

        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSmsMessage model) {
            body(model.body);
            messageType(model.messageType);
            originationNumber(model.originationNumber);
            senderId(model.senderId);
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getMessageType() {
            return messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getOriginationNumber() {
            return originationNumber;
        }

        @Override
        public final Builder originationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public final void setOriginationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
        }

        public final String getSenderId() {
            return senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public CampaignSmsMessage build() {
            return new CampaignSmsMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
