/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCampaignRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateCampaignRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::applicationId)).setter(UpdateCampaignRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignId").getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::campaignId)).setter(UpdateCampaignRequest.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("campaign-id").build()}).build();
    private static final SdkField<WriteCampaignRequest> WRITE_CAMPAIGN_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WriteCampaignRequest").getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::writeCampaignRequest)).setter(UpdateCampaignRequest.setter(Builder::writeCampaignRequest)).constructor(WriteCampaignRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCampaignRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CAMPAIGN_ID_FIELD, WRITE_CAMPAIGN_REQUEST_FIELD));
    private final String applicationId;
    private final String campaignId;
    private final WriteCampaignRequest writeCampaignRequest;

    private UpdateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.writeCampaignRequest = builder.writeCampaignRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final WriteCampaignRequest writeCampaignRequest() {
        return this.writeCampaignRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeCampaignRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignRequest)) {
            return false;
        }
        UpdateCampaignRequest other = (UpdateCampaignRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.writeCampaignRequest(), other.writeCampaignRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCampaignRequest").add("ApplicationId", (Object)this.applicationId()).add("CampaignId", (Object)this.campaignId()).add("WriteCampaignRequest", (Object)this.writeCampaignRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CampaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "WriteCampaignRequest": {
                return Optional.ofNullable(clazz.cast(this.writeCampaignRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignRequest, T> g) {
        return obj -> g.apply((UpdateCampaignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String campaignId;
        private WriteCampaignRequest writeCampaignRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.campaignId(model.campaignId);
            this.writeCampaignRequest(model.writeCampaignRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        public final WriteCampaignRequest.Builder getWriteCampaignRequest() {
            return this.writeCampaignRequest != null ? this.writeCampaignRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeCampaignRequest(WriteCampaignRequest writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest;
            return this;
        }

        public final void setWriteCampaignRequest(WriteCampaignRequest.BuilderImpl writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest != null ? writeCampaignRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignRequest build() {
            return new UpdateCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCampaignRequest> {
        public Builder applicationId(String var1);

        public Builder campaignId(String var1);

        public Builder writeCampaignRequest(WriteCampaignRequest var1);

        default public Builder writeCampaignRequest(Consumer<WriteCampaignRequest.Builder> writeCampaignRequest) {
            return this.writeCampaignRequest((WriteCampaignRequest)((WriteCampaignRequest.Builder)WriteCampaignRequest.builder().applyMutation(writeCampaignRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

