/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCampaignVersionRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, GetCampaignVersionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(GetCampaignVersionRequest.getter(GetCampaignVersionRequest::applicationId)).setter(GetCampaignVersionRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignId").getter(GetCampaignVersionRequest.getter(GetCampaignVersionRequest::campaignId)).setter(GetCampaignVersionRequest.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("campaign-id").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(GetCampaignVersionRequest.getter(GetCampaignVersionRequest::version)).setter(GetCampaignVersionRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CAMPAIGN_ID_FIELD, VERSION_FIELD));
    private final String applicationId;
    private final String campaignId;
    private final String version;

    private GetCampaignVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String campaignId() {
        return this.campaignId;
    }

    public String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignVersionRequest)) {
            return false;
        }
        GetCampaignVersionRequest other = (GetCampaignVersionRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"GetCampaignVersionRequest").add("ApplicationId", (Object)this.applicationId()).add("CampaignId", (Object)this.campaignId()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CampaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignVersionRequest, T> g) {
        return obj -> g.apply((GetCampaignVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String campaignId;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignVersionRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.campaignId(model.campaignId);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCampaignVersionRequest build() {
            return new GetCampaignVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCampaignVersionRequest> {
        public Builder applicationId(String var1);

        public Builder campaignId(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

