/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem;
import software.amazon.awssdk.services.pinpoint.model.ListOfEndpointBatchItemCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointBatchRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointBatchRequest> {
    private static final SdkField<List<EndpointBatchItem>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Item").getter(EndpointBatchRequest.getter(EndpointBatchRequest::item)).setter(EndpointBatchRequest.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointBatchItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<EndpointBatchItem> item;

    private EndpointBatchRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    public boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructList);
    }

    public List<EndpointBatchItem> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointBatchRequest)) {
            return false;
        }
        EndpointBatchRequest other = (EndpointBatchRequest)obj;
        return Objects.equals(this.item(), other.item());
    }

    public String toString() {
        return ToString.builder((String)"EndpointBatchRequest").add("Item", this.item()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointBatchRequest, T> g) {
        return obj -> g.apply((EndpointBatchRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EndpointBatchItem> item = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointBatchRequest model) {
            this.item(model.item);
        }

        public final Collection<EndpointBatchItem.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(EndpointBatchItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<EndpointBatchItem> item) {
            this.item = ListOfEndpointBatchItemCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(EndpointBatchItem ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<EndpointBatchItem.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (EndpointBatchItem)((EndpointBatchItem.Builder)EndpointBatchItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<EndpointBatchItem.BuilderImpl> item) {
            this.item = ListOfEndpointBatchItemCopier.copyFromBuilder(item);
        }

        public EndpointBatchRequest build() {
            return new EndpointBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointBatchRequest> {
        public Builder item(Collection<EndpointBatchItem> var1);

        public Builder item(EndpointBatchItem ... var1);

        public Builder item(Consumer<EndpointBatchItem.Builder> ... var1);
    }
}

