/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Condition;
import software.amazon.awssdk.services.pinpoint.model.WaitTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionalSplitActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionalSplitActivity> {
    private static final SdkField<Condition> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Condition").getter(ConditionalSplitActivity.getter(ConditionalSplitActivity::condition)).setter(ConditionalSplitActivity.setter(Builder::condition)).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final SdkField<WaitTime> EVALUATION_WAIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationWaitTime").getter(ConditionalSplitActivity.getter(ConditionalSplitActivity::evaluationWaitTime)).setter(ConditionalSplitActivity.setter(Builder::evaluationWaitTime)).constructor(WaitTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationWaitTime").build()}).build();
    private static final SdkField<String> FALSE_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FalseActivity").getter(ConditionalSplitActivity.getter(ConditionalSplitActivity::falseActivity)).setter(ConditionalSplitActivity.setter(Builder::falseActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FalseActivity").build()}).build();
    private static final SdkField<String> TRUE_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrueActivity").getter(ConditionalSplitActivity.getter(ConditionalSplitActivity::trueActivity)).setter(ConditionalSplitActivity.setter(Builder::trueActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrueActivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD, EVALUATION_WAIT_TIME_FIELD, FALSE_ACTIVITY_FIELD, TRUE_ACTIVITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Condition condition;
    private final WaitTime evaluationWaitTime;
    private final String falseActivity;
    private final String trueActivity;

    private ConditionalSplitActivity(BuilderImpl builder) {
        this.condition = builder.condition;
        this.evaluationWaitTime = builder.evaluationWaitTime;
        this.falseActivity = builder.falseActivity;
        this.trueActivity = builder.trueActivity;
    }

    public Condition condition() {
        return this.condition;
    }

    public WaitTime evaluationWaitTime() {
        return this.evaluationWaitTime;
    }

    public String falseActivity() {
        return this.falseActivity;
    }

    public String trueActivity() {
        return this.trueActivity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationWaitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.falseActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.trueActivity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalSplitActivity)) {
            return false;
        }
        ConditionalSplitActivity other = (ConditionalSplitActivity)obj;
        return Objects.equals(this.condition(), other.condition()) && Objects.equals(this.evaluationWaitTime(), other.evaluationWaitTime()) && Objects.equals(this.falseActivity(), other.falseActivity()) && Objects.equals(this.trueActivity(), other.trueActivity());
    }

    public String toString() {
        return ToString.builder((String)"ConditionalSplitActivity").add("Condition", (Object)this.condition()).add("EvaluationWaitTime", (Object)this.evaluationWaitTime()).add("FalseActivity", (Object)this.falseActivity()).add("TrueActivity", (Object)this.trueActivity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "EvaluationWaitTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationWaitTime()));
            }
            case "FalseActivity": {
                return Optional.ofNullable(clazz.cast(this.falseActivity()));
            }
            case "TrueActivity": {
                return Optional.ofNullable(clazz.cast(this.trueActivity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionalSplitActivity, T> g) {
        return obj -> g.apply((ConditionalSplitActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Condition condition;
        private WaitTime evaluationWaitTime;
        private String falseActivity;
        private String trueActivity;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalSplitActivity model) {
            this.condition(model.condition);
            this.evaluationWaitTime(model.evaluationWaitTime);
            this.falseActivity(model.falseActivity);
            this.trueActivity(model.trueActivity);
        }

        public final Condition.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        public final WaitTime.Builder getEvaluationWaitTime() {
            return this.evaluationWaitTime != null ? this.evaluationWaitTime.toBuilder() : null;
        }

        @Override
        public final Builder evaluationWaitTime(WaitTime evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime;
            return this;
        }

        public final void setEvaluationWaitTime(WaitTime.BuilderImpl evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime != null ? evaluationWaitTime.build() : null;
        }

        public final String getFalseActivity() {
            return this.falseActivity;
        }

        @Override
        public final Builder falseActivity(String falseActivity) {
            this.falseActivity = falseActivity;
            return this;
        }

        public final void setFalseActivity(String falseActivity) {
            this.falseActivity = falseActivity;
        }

        public final String getTrueActivity() {
            return this.trueActivity;
        }

        @Override
        public final Builder trueActivity(String trueActivity) {
            this.trueActivity = trueActivity;
            return this;
        }

        public final void setTrueActivity(String trueActivity) {
            this.trueActivity = trueActivity;
        }

        public ConditionalSplitActivity build() {
            return new ConditionalSplitActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionalSplitActivity> {
        public Builder condition(Condition var1);

        default public Builder condition(Consumer<Condition.Builder> condition) {
            return this.condition((Condition)((Condition.Builder)Condition.builder().applyMutation(condition)).build());
        }

        public Builder evaluationWaitTime(WaitTime var1);

        default public Builder evaluationWaitTime(Consumer<WaitTime.Builder> evaluationWaitTime) {
            return this.evaluationWaitTime((WaitTime)((WaitTime.Builder)WaitTime.builder().applyMutation(evaluationWaitTime)).build());
        }

        public Builder falseActivity(String var1);

        public Builder trueActivity(String var1);
    }
}

