/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailTemplateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailTemplateRequest> {
    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSubstitutions").getter(EmailTemplateRequest.getter(EmailTemplateRequest::defaultSubstitutions)).setter(EmailTemplateRequest.setter(Builder::defaultSubstitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build()}).build();
    private static final SdkField<String> HTML_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HtmlPart").getter(EmailTemplateRequest.getter(EmailTemplateRequest::htmlPart)).setter(EmailTemplateRequest.setter(Builder::htmlPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()}).build();
    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderId").getter(EmailTemplateRequest.getter(EmailTemplateRequest::recommenderId)).setter(EmailTemplateRequest.setter(Builder::recommenderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(EmailTemplateRequest.getter(EmailTemplateRequest::subject)).setter(EmailTemplateRequest.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(EmailTemplateRequest.getter(EmailTemplateRequest::tags)).setter(EmailTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateDescription").getter(EmailTemplateRequest.getter(EmailTemplateRequest::templateDescription)).setter(EmailTemplateRequest.setter(Builder::templateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build()}).build();
    private static final SdkField<String> TEXT_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextPart").getter(EmailTemplateRequest.getter(EmailTemplateRequest::textPart)).setter(EmailTemplateRequest.setter(Builder::textPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_SUBSTITUTIONS_FIELD, HTML_PART_FIELD, RECOMMENDER_ID_FIELD, SUBJECT_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEXT_PART_FIELD));
    private static final long serialVersionUID = 1L;
    private final String defaultSubstitutions;
    private final String htmlPart;
    private final String recommenderId;
    private final String subject;
    private final Map<String, String> tags;
    private final String templateDescription;
    private final String textPart;

    private EmailTemplateRequest(BuilderImpl builder) {
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.htmlPart = builder.htmlPart;
        this.recommenderId = builder.recommenderId;
        this.subject = builder.subject;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.textPart = builder.textPart;
    }

    public String defaultSubstitutions() {
        return this.defaultSubstitutions;
    }

    public String htmlPart() {
        return this.htmlPart;
    }

    public String recommenderId() {
        return this.recommenderId;
    }

    public String subject() {
        return this.subject;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String templateDescription() {
        return this.templateDescription;
    }

    public String textPart() {
        return this.textPart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.textPart());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateRequest)) {
            return false;
        }
        EmailTemplateRequest other = (EmailTemplateRequest)obj;
        return Objects.equals(this.defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(this.htmlPart(), other.htmlPart()) && Objects.equals(this.recommenderId(), other.recommenderId()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateDescription(), other.templateDescription()) && Objects.equals(this.textPart(), other.textPart());
    }

    public String toString() {
        return ToString.builder((String)"EmailTemplateRequest").add("DefaultSubstitutions", (Object)this.defaultSubstitutions()).add("HtmlPart", (Object)this.htmlPart()).add("RecommenderId", (Object)this.recommenderId()).add("Subject", (Object)this.subject()).add("Tags", this.tags()).add("TemplateDescription", (Object)this.templateDescription()).add("TextPart", (Object)this.textPart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultSubstitutions": {
                return Optional.ofNullable(clazz.cast(this.defaultSubstitutions()));
            }
            case "HtmlPart": {
                return Optional.ofNullable(clazz.cast(this.htmlPart()));
            }
            case "RecommenderId": {
                return Optional.ofNullable(clazz.cast(this.recommenderId()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateDescription": {
                return Optional.ofNullable(clazz.cast(this.templateDescription()));
            }
            case "TextPart": {
                return Optional.ofNullable(clazz.cast(this.textPart()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailTemplateRequest, T> g) {
        return obj -> g.apply((EmailTemplateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultSubstitutions;
        private String htmlPart;
        private String recommenderId;
        private String subject;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateDescription;
        private String textPart;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailTemplateRequest model) {
            this.defaultSubstitutions(model.defaultSubstitutions);
            this.htmlPart(model.htmlPart);
            this.recommenderId(model.recommenderId);
            this.subject(model.subject);
            this.tags(model.tags);
            this.templateDescription(model.templateDescription);
            this.textPart(model.textPart);
        }

        public final String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        public final String getHtmlPart() {
            return this.htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        public final String getRecommenderId() {
            return this.recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final String getTextPart() {
            return this.textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        public EmailTemplateRequest build() {
            return new EmailTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailTemplateRequest> {
        public Builder defaultSubstitutions(String var1);

        public Builder htmlPart(String var1);

        public Builder recommenderId(String var1);

        public Builder subject(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateDescription(String var1);

        public Builder textPart(String var1);
    }
}

