/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSegmentRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateSegmentRequest.Builder, UpdateSegmentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSegmentRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSegmentRequest::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("segment-id").build()).build();

    private static final SdkField<WriteSegmentRequest> WRITE_SEGMENT_REQUEST_FIELD = SdkField
            .<WriteSegmentRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateSegmentRequest::writeSegmentRequest))
            .setter(setter(Builder::writeSegmentRequest))
            .constructor(WriteSegmentRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteSegmentRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            SEGMENT_ID_FIELD, WRITE_SEGMENT_REQUEST_FIELD));

    private final String applicationId;

    private final String segmentId;

    private final WriteSegmentRequest writeSegmentRequest;

    private UpdateSegmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.segmentId = builder.segmentId;
        this.writeSegmentRequest = builder.writeSegmentRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the segment.
     * </p>
     * 
     * @return The unique identifier for the segment.
     */
    public String segmentId() {
        return segmentId;
    }

    /**
     * Returns the value of the WriteSegmentRequest property for this object.
     * 
     * @return The value of the WriteSegmentRequest property for this object.
     */
    public WriteSegmentRequest writeSegmentRequest() {
        return writeSegmentRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(writeSegmentRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSegmentRequest)) {
            return false;
        }
        UpdateSegmentRequest other = (UpdateSegmentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(segmentId(), other.segmentId())
                && Objects.equals(writeSegmentRequest(), other.writeSegmentRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSegmentRequest").add("ApplicationId", applicationId()).add("SegmentId", segmentId())
                .add("WriteSegmentRequest", writeSegmentRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "WriteSegmentRequest":
            return Optional.ofNullable(clazz.cast(writeSegmentRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSegmentRequest, T> g) {
        return obj -> g.apply((UpdateSegmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSegmentRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the segment.
         * </p>
         * 
         * @param segmentId
         *        The unique identifier for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * Sets the value of the WriteSegmentRequest property for this object.
         *
         * @param writeSegmentRequest
         *        The new value for the WriteSegmentRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeSegmentRequest(WriteSegmentRequest writeSegmentRequest);

        /**
         * Sets the value of the WriteSegmentRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link WriteSegmentRequest.Builder} avoiding the need
         * to create one manually via {@link WriteSegmentRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link WriteSegmentRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #writeSegmentRequest(WriteSegmentRequest)}.
         * 
         * @param writeSegmentRequest
         *        a consumer that will call methods on {@link WriteSegmentRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeSegmentRequest(WriteSegmentRequest)
         */
        default Builder writeSegmentRequest(Consumer<WriteSegmentRequest.Builder> writeSegmentRequest) {
            return writeSegmentRequest(WriteSegmentRequest.builder().applyMutation(writeSegmentRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String segmentId;

        private WriteSegmentRequest writeSegmentRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSegmentRequest model) {
            super(model);
            applicationId(model.applicationId);
            segmentId(model.segmentId);
            writeSegmentRequest(model.writeSegmentRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final WriteSegmentRequest.Builder getWriteSegmentRequest() {
            return writeSegmentRequest != null ? writeSegmentRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeSegmentRequest(WriteSegmentRequest writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest;
            return this;
        }

        public final void setWriteSegmentRequest(WriteSegmentRequest.BuilderImpl writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest != null ? writeSegmentRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSegmentRequest build() {
            return new UpdateSegmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
