/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the dimension type and values for a segment dimension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetDimension implements SdkPojo, Serializable, ToCopyableBuilder<SetDimension.Builder, SetDimension> {
    private static final SdkField<String> DIMENSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetDimension::dimensionTypeAsString)).setter(setter(Builder::dimensionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionType").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SetDimension::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_TYPE_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dimensionType;

    private final List<String> values;

    private SetDimension(BuilderImpl builder) {
        this.dimensionType = builder.dimensionType;
        this.values = builder.values;
    }

    /**
     * <p>
     * The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are included
     * in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimensionType}
     * will return {@link DimensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionTypeAsString}.
     * </p>
     * 
     * @return The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are
     *         included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.
     * @see DimensionType
     */
    public DimensionType dimensionType() {
        return DimensionType.fromValue(dimensionType);
    }

    /**
     * <p>
     * The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are included
     * in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimensionType}
     * will return {@link DimensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionTypeAsString}.
     * </p>
     * 
     * @return The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are
     *         included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.
     * @see DimensionType
     */
    public String dimensionTypeAsString() {
        return dimensionType;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria values to use for the segment dimension. Depending on the value of the DimensionType property,
     * endpoints are included or excluded from the segment if their values match the criteria values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The criteria values to use for the segment dimension. Depending on the value of the DimensionType
     *         property, endpoints are included or excluded from the segment if their values match the criteria values.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDimension)) {
            return false;
        }
        SetDimension other = (SetDimension) obj;
        return Objects.equals(dimensionTypeAsString(), other.dimensionTypeAsString()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetDimension").add("DimensionType", dimensionTypeAsString()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionType":
            return Optional.ofNullable(clazz.cast(dimensionTypeAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetDimension, T> g) {
        return obj -> g.apply((SetDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetDimension> {
        /**
         * <p>
         * The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are
         * included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.
         * </p>
         * 
         * @param dimensionType
         *        The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria
         *        are included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the
         *        segment.
         * @see DimensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionType
         */
        Builder dimensionType(String dimensionType);

        /**
         * <p>
         * The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are
         * included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.
         * </p>
         * 
         * @param dimensionType
         *        The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria
         *        are included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the
         *        segment.
         * @see DimensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionType
         */
        Builder dimensionType(DimensionType dimensionType);

        /**
         * <p>
         * The criteria values to use for the segment dimension. Depending on the value of the DimensionType property,
         * endpoints are included or excluded from the segment if their values match the criteria values.
         * </p>
         * 
         * @param values
         *        The criteria values to use for the segment dimension. Depending on the value of the DimensionType
         *        property, endpoints are included or excluded from the segment if their values match the criteria
         *        values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The criteria values to use for the segment dimension. Depending on the value of the DimensionType property,
         * endpoints are included or excluded from the segment if their values match the criteria values.
         * </p>
         * 
         * @param values
         *        The criteria values to use for the segment dimension. Depending on the value of the DimensionType
         *        property, endpoints are included or excluded from the segment if their values match the criteria
         *        values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionType;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetDimension model) {
            dimensionType(model.dimensionType);
            values(model.values);
        }

        public final String getDimensionType() {
            return dimensionType;
        }

        @Override
        public final Builder dimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
            return this;
        }

        @Override
        public final Builder dimensionType(DimensionType dimensionType) {
            this.dimensionType(dimensionType == null ? null : dimensionType.toString());
            return this;
        }

        public final void setDimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
        }

        @Override
        public SetDimension build() {
            return new SetDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
