/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSmsChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<GetSmsChannelResponse.Builder, GetSmsChannelResponse> {
    private static final SdkField<SMSChannelResponse> SMS_CHANNEL_RESPONSE_FIELD = SdkField
            .<SMSChannelResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSmsChannelResponse::smsChannelResponse))
            .setter(setter(Builder::smsChannelResponse))
            .constructor(SMSChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_CHANNEL_RESPONSE_FIELD));

    private final SMSChannelResponse smsChannelResponse;

    private GetSmsChannelResponse(BuilderImpl builder) {
        super(builder);
        this.smsChannelResponse = builder.smsChannelResponse;
    }

    /**
     * Returns the value of the SMSChannelResponse property for this object.
     * 
     * @return The value of the SMSChannelResponse property for this object.
     */
    public SMSChannelResponse smsChannelResponse() {
        return smsChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(smsChannelResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSmsChannelResponse)) {
            return false;
        }
        GetSmsChannelResponse other = (GetSmsChannelResponse) obj;
        return Objects.equals(smsChannelResponse(), other.smsChannelResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSmsChannelResponse").add("SMSChannelResponse", smsChannelResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SMSChannelResponse":
            return Optional.ofNullable(clazz.cast(smsChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSmsChannelResponse, T> g) {
        return obj -> g.apply((GetSmsChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSmsChannelResponse> {
        /**
         * Sets the value of the SMSChannelResponse property for this object.
         *
         * @param smsChannelResponse
         *        The new value for the SMSChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsChannelResponse(SMSChannelResponse smsChannelResponse);

        /**
         * Sets the value of the SMSChannelResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link SMSChannelResponse.Builder} avoiding the need to
         * create one manually via {@link SMSChannelResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link SMSChannelResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #smsChannelResponse(SMSChannelResponse)}.
         * 
         * @param smsChannelResponse
         *        a consumer that will call methods on {@link SMSChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsChannelResponse(SMSChannelResponse)
         */
        default Builder smsChannelResponse(Consumer<SMSChannelResponse.Builder> smsChannelResponse) {
            return smsChannelResponse(SMSChannelResponse.builder().applyMutation(smsChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private SMSChannelResponse smsChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSmsChannelResponse model) {
            super(model);
            smsChannelResponse(model.smsChannelResponse);
        }

        public final SMSChannelResponse.Builder getSmsChannelResponse() {
            return smsChannelResponse != null ? smsChannelResponse.toBuilder() : null;
        }

        @Override
        public final Builder smsChannelResponse(SMSChannelResponse smsChannelResponse) {
            this.smsChannelResponse = smsChannelResponse;
            return this;
        }

        public final void setSmsChannelResponse(SMSChannelResponse.BuilderImpl smsChannelResponse) {
            this.smsChannelResponse = smsChannelResponse != null ? smsChannelResponse.build() : null;
        }

        @Override
        public GetSmsChannelResponse build() {
            return new GetSmsChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
