/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEmailTemplateResponse extends PinpointResponse implements
        ToCopyableBuilder<GetEmailTemplateResponse.Builder, GetEmailTemplateResponse> {
    private static final SdkField<EmailTemplateResponse> EMAIL_TEMPLATE_RESPONSE_FIELD = SdkField
            .<EmailTemplateResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetEmailTemplateResponse::emailTemplateResponse))
            .setter(setter(Builder::emailTemplateResponse))
            .constructor(EmailTemplateResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTemplateResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EMAIL_TEMPLATE_RESPONSE_FIELD));

    private final EmailTemplateResponse emailTemplateResponse;

    private GetEmailTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.emailTemplateResponse = builder.emailTemplateResponse;
    }

    /**
     * Returns the value of the EmailTemplateResponse property for this object.
     * 
     * @return The value of the EmailTemplateResponse property for this object.
     */
    public EmailTemplateResponse emailTemplateResponse() {
        return emailTemplateResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailTemplateResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEmailTemplateResponse)) {
            return false;
        }
        GetEmailTemplateResponse other = (GetEmailTemplateResponse) obj;
        return Objects.equals(emailTemplateResponse(), other.emailTemplateResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetEmailTemplateResponse").add("EmailTemplateResponse", emailTemplateResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailTemplateResponse":
            return Optional.ofNullable(clazz.cast(emailTemplateResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEmailTemplateResponse, T> g) {
        return obj -> g.apply((GetEmailTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEmailTemplateResponse> {
        /**
         * Sets the value of the EmailTemplateResponse property for this object.
         *
         * @param emailTemplateResponse
         *        The new value for the EmailTemplateResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailTemplateResponse(EmailTemplateResponse emailTemplateResponse);

        /**
         * Sets the value of the EmailTemplateResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link EmailTemplateResponse.Builder} avoiding the need
         * to create one manually via {@link EmailTemplateResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailTemplateResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #emailTemplateResponse(EmailTemplateResponse)}.
         * 
         * @param emailTemplateResponse
         *        a consumer that will call methods on {@link EmailTemplateResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailTemplateResponse(EmailTemplateResponse)
         */
        default Builder emailTemplateResponse(Consumer<EmailTemplateResponse.Builder> emailTemplateResponse) {
            return emailTemplateResponse(EmailTemplateResponse.builder().applyMutation(emailTemplateResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private EmailTemplateResponse emailTemplateResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEmailTemplateResponse model) {
            super(model);
            emailTemplateResponse(model.emailTemplateResponse);
        }

        public final EmailTemplateResponse.Builder getEmailTemplateResponse() {
            return emailTemplateResponse != null ? emailTemplateResponse.toBuilder() : null;
        }

        @Override
        public final Builder emailTemplateResponse(EmailTemplateResponse emailTemplateResponse) {
            this.emailTemplateResponse = emailTemplateResponse;
            return this;
        }

        public final void setEmailTemplateResponse(EmailTemplateResponse.BuilderImpl emailTemplateResponse) {
            this.emailTemplateResponse = emailTemplateResponse != null ? emailTemplateResponse.build() : null;
        }

        @Override
        public GetEmailTemplateResponse build() {
            return new GetEmailTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
