/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOfTemplateVersionResponseCopier;
import software.amazon.awssdk.services.pinpoint.model.TemplateVersionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateVersionsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateVersionsResponse> {
    private static final SdkField<List<TemplateVersionResponse>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TemplateVersionsResponse.getter(TemplateVersionsResponse::item)).setter(TemplateVersionsResponse.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateVersionResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TemplateVersionsResponse.getter(TemplateVersionsResponse::message)).setter(TemplateVersionsResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TemplateVersionsResponse.getter(TemplateVersionsResponse::nextToken)).setter(TemplateVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TemplateVersionsResponse.getter(TemplateVersionsResponse::requestID)).setter(TemplateVersionsResponse.setter(Builder::requestID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, MESSAGE_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TemplateVersionResponse> item;
    private final String message;
    private final String nextToken;
    private final String requestID;

    private TemplateVersionsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.message = builder.message;
        this.nextToken = builder.nextToken;
        this.requestID = builder.requestID;
    }

    public boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructList);
    }

    public List<TemplateVersionResponse> item() {
        return this.item;
    }

    public String message() {
        return this.message;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String requestID() {
        return this.requestID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestID());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateVersionsResponse)) {
            return false;
        }
        TemplateVersionsResponse other = (TemplateVersionsResponse)obj;
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestID(), other.requestID());
    }

    public String toString() {
        return ToString.builder((String)"TemplateVersionsResponse").add("Item", this.item()).add("Message", (Object)this.message()).add("NextToken", (Object)this.nextToken()).add("RequestID", (Object)this.requestID()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestID": {
                return Optional.ofNullable(clazz.cast(this.requestID()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateVersionsResponse, T> g) {
        return obj -> g.apply((TemplateVersionsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TemplateVersionResponse> item = DefaultSdkAutoConstructList.getInstance();
        private String message;
        private String nextToken;
        private String requestID;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateVersionsResponse model) {
            this.item(model.item);
            this.message(model.message);
            this.nextToken(model.nextToken);
            this.requestID(model.requestID);
        }

        public final Collection<TemplateVersionResponse.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(TemplateVersionResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<TemplateVersionResponse> item) {
            this.item = ListOfTemplateVersionResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(TemplateVersionResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<TemplateVersionResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (TemplateVersionResponse)((TemplateVersionResponse.Builder)TemplateVersionResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<TemplateVersionResponse.BuilderImpl> item) {
            this.item = ListOfTemplateVersionResponseCopier.copyFromBuilder(item);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestID() {
            return this.requestID;
        }

        @Override
        public final Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public final void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public TemplateVersionsResponse build() {
            return new TemplateVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateVersionsResponse> {
        public Builder item(Collection<TemplateVersionResponse> var1);

        public Builder item(TemplateVersionResponse ... var1);

        public Builder item(Consumer<TemplateVersionResponse.Builder> ... var1);

        public Builder message(String var1);

        public Builder nextToken(String var1);

        public Builder requestID(String var1);
    }
}

