/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JourneyExecutionActivityMetricsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JourneyExecutionActivityMetricsResponse> {
    private static final SdkField<String> ACTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JourneyExecutionActivityMetricsResponse.getter(JourneyExecutionActivityMetricsResponse::activityType)).setter(JourneyExecutionActivityMetricsResponse.setter(Builder::activityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityType").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JourneyExecutionActivityMetricsResponse.getter(JourneyExecutionActivityMetricsResponse::applicationId)).setter(JourneyExecutionActivityMetricsResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> JOURNEY_ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JourneyExecutionActivityMetricsResponse.getter(JourneyExecutionActivityMetricsResponse::journeyActivityId)).setter(JourneyExecutionActivityMetricsResponse.setter(Builder::journeyActivityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyActivityId").build()}).build();
    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JourneyExecutionActivityMetricsResponse.getter(JourneyExecutionActivityMetricsResponse::journeyId)).setter(JourneyExecutionActivityMetricsResponse.setter(Builder::journeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyId").build()}).build();
    private static final SdkField<String> LAST_EVALUATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JourneyExecutionActivityMetricsResponse.getter(JourneyExecutionActivityMetricsResponse::lastEvaluatedTime)).setter(JourneyExecutionActivityMetricsResponse.setter(Builder::lastEvaluatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTime").build()}).build();
    private static final SdkField<Map<String, String>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(JourneyExecutionActivityMetricsResponse.getter(JourneyExecutionActivityMetricsResponse::metrics)).setter(JourneyExecutionActivityMetricsResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD, APPLICATION_ID_FIELD, JOURNEY_ACTIVITY_ID_FIELD, JOURNEY_ID_FIELD, LAST_EVALUATED_TIME_FIELD, METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activityType;
    private final String applicationId;
    private final String journeyActivityId;
    private final String journeyId;
    private final String lastEvaluatedTime;
    private final Map<String, String> metrics;

    private JourneyExecutionActivityMetricsResponse(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.applicationId = builder.applicationId;
        this.journeyActivityId = builder.journeyActivityId;
        this.journeyId = builder.journeyId;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.metrics = builder.metrics;
    }

    public String activityType() {
        return this.activityType;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String journeyActivityId() {
        return this.journeyActivityId;
    }

    public String journeyId() {
        return this.journeyId;
    }

    public String lastEvaluatedTime() {
        return this.lastEvaluatedTime;
    }

    public boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public Map<String, String> metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyActivityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyExecutionActivityMetricsResponse)) {
            return false;
        }
        JourneyExecutionActivityMetricsResponse other = (JourneyExecutionActivityMetricsResponse)obj;
        return Objects.equals(this.activityType(), other.activityType()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.journeyActivityId(), other.journeyActivityId()) && Objects.equals(this.journeyId(), other.journeyId()) && Objects.equals(this.lastEvaluatedTime(), other.lastEvaluatedTime()) && Objects.equals(this.metrics(), other.metrics());
    }

    public String toString() {
        return ToString.builder((String)"JourneyExecutionActivityMetricsResponse").add("ActivityType", (Object)this.activityType()).add("ApplicationId", (Object)this.applicationId()).add("JourneyActivityId", (Object)this.journeyActivityId()).add("JourneyId", (Object)this.journeyId()).add("LastEvaluatedTime", (Object)this.lastEvaluatedTime()).add("Metrics", this.metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityType": {
                return Optional.ofNullable(clazz.cast(this.activityType()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "JourneyActivityId": {
                return Optional.ofNullable(clazz.cast(this.journeyActivityId()));
            }
            case "JourneyId": {
                return Optional.ofNullable(clazz.cast(this.journeyId()));
            }
            case "LastEvaluatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTime()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyExecutionActivityMetricsResponse, T> g) {
        return obj -> g.apply((JourneyExecutionActivityMetricsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activityType;
        private String applicationId;
        private String journeyActivityId;
        private String journeyId;
        private String lastEvaluatedTime;
        private Map<String, String> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyExecutionActivityMetricsResponse model) {
            this.activityType(model.activityType);
            this.applicationId(model.applicationId);
            this.journeyActivityId(model.journeyActivityId);
            this.journeyId(model.journeyId);
            this.lastEvaluatedTime(model.lastEvaluatedTime);
            this.metrics(model.metrics);
        }

        public final String getActivityType() {
            return this.activityType;
        }

        @Override
        public final Builder activityType(String activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(String activityType) {
            this.activityType = activityType;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getJourneyActivityId() {
            return this.journeyActivityId;
        }

        @Override
        public final Builder journeyActivityId(String journeyActivityId) {
            this.journeyActivityId = journeyActivityId;
            return this;
        }

        public final void setJourneyActivityId(String journeyActivityId) {
            this.journeyActivityId = journeyActivityId;
        }

        public final String getJourneyId() {
            return this.journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        public final String getLastEvaluatedTime() {
            return this.lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final void setLastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        public final Map<String, String> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
        }

        public JourneyExecutionActivityMetricsResponse build() {
            return new JourneyExecutionActivityMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JourneyExecutionActivityMetricsResponse> {
        public Builder activityType(String var1);

        public Builder applicationId(String var1);

        public Builder journeyActivityId(String var1);

        public Builder journeyId(String var1);

        public Builder lastEvaluatedTime(String var1);

        public Builder metrics(Map<String, String> var1);
    }
}

