/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.APNSPushNotificationTemplate;
import software.amazon.awssdk.services.pinpoint.model.AndroidPushNotificationTemplate;
import software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationTemplate;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushNotificationTemplateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushNotificationTemplateRequest> {
    private static final SdkField<AndroidPushNotificationTemplate> ADM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::adm)).setter(PushNotificationTemplateRequest.setter(Builder::adm)).constructor(AndroidPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADM").build()}).build();
    private static final SdkField<APNSPushNotificationTemplate> APNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::apns)).setter(PushNotificationTemplateRequest.setter(Builder::apns)).constructor(APNSPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNS").build()}).build();
    private static final SdkField<AndroidPushNotificationTemplate> BAIDU_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::baidu)).setter(PushNotificationTemplateRequest.setter(Builder::baidu)).constructor(AndroidPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Baidu").build()}).build();
    private static final SdkField<DefaultPushNotificationTemplate> DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::defaultValue)).setter(PushNotificationTemplateRequest.setter(Builder::defaultValue)).constructor(DefaultPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Default").build()}).build();
    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::defaultSubstitutions)).setter(PushNotificationTemplateRequest.setter(Builder::defaultSubstitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build()}).build();
    private static final SdkField<AndroidPushNotificationTemplate> GCM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::gcm)).setter(PushNotificationTemplateRequest.setter(Builder::gcm)).constructor(AndroidPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCM").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::tags)).setter(PushNotificationTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PushNotificationTemplateRequest.getter(PushNotificationTemplateRequest::templateDescription)).setter(PushNotificationTemplateRequest.setter(Builder::templateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_FIELD, APNS_FIELD, BAIDU_FIELD, DEFAULT_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, GCM_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AndroidPushNotificationTemplate adm;
    private final APNSPushNotificationTemplate apns;
    private final AndroidPushNotificationTemplate baidu;
    private final DefaultPushNotificationTemplate defaultValue;
    private final String defaultSubstitutions;
    private final AndroidPushNotificationTemplate gcm;
    private final Map<String, String> tags;
    private final String templateDescription;

    private PushNotificationTemplateRequest(BuilderImpl builder) {
        this.adm = builder.adm;
        this.apns = builder.apns;
        this.baidu = builder.baidu;
        this.defaultValue = builder.defaultValue;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.gcm = builder.gcm;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
    }

    public AndroidPushNotificationTemplate adm() {
        return this.adm;
    }

    public APNSPushNotificationTemplate apns() {
        return this.apns;
    }

    public AndroidPushNotificationTemplate baidu() {
        return this.baidu;
    }

    public DefaultPushNotificationTemplate defaultValue() {
        return this.defaultValue;
    }

    public String defaultSubstitutions() {
        return this.defaultSubstitutions;
    }

    public AndroidPushNotificationTemplate gcm() {
        return this.gcm;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String templateDescription() {
        return this.templateDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adm());
        hashCode = 31 * hashCode + Objects.hashCode(this.apns());
        hashCode = 31 * hashCode + Objects.hashCode(this.baidu());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcm());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushNotificationTemplateRequest)) {
            return false;
        }
        PushNotificationTemplateRequest other = (PushNotificationTemplateRequest)obj;
        return Objects.equals(this.adm(), other.adm()) && Objects.equals(this.apns(), other.apns()) && Objects.equals(this.baidu(), other.baidu()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(this.gcm(), other.gcm()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateDescription(), other.templateDescription());
    }

    public String toString() {
        return ToString.builder((String)"PushNotificationTemplateRequest").add("ADM", (Object)this.adm()).add("APNS", (Object)this.apns()).add("Baidu", (Object)this.baidu()).add("Default", (Object)this.defaultValue()).add("DefaultSubstitutions", (Object)this.defaultSubstitutions()).add("GCM", (Object)this.gcm()).add("Tags", this.tags()).add("TemplateDescription", (Object)this.templateDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ADM": {
                return Optional.ofNullable(clazz.cast(this.adm()));
            }
            case "APNS": {
                return Optional.ofNullable(clazz.cast(this.apns()));
            }
            case "Baidu": {
                return Optional.ofNullable(clazz.cast(this.baidu()));
            }
            case "Default": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "DefaultSubstitutions": {
                return Optional.ofNullable(clazz.cast(this.defaultSubstitutions()));
            }
            case "GCM": {
                return Optional.ofNullable(clazz.cast(this.gcm()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateDescription": {
                return Optional.ofNullable(clazz.cast(this.templateDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushNotificationTemplateRequest, T> g) {
        return obj -> g.apply((PushNotificationTemplateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AndroidPushNotificationTemplate adm;
        private APNSPushNotificationTemplate apns;
        private AndroidPushNotificationTemplate baidu;
        private DefaultPushNotificationTemplate defaultValue;
        private String defaultSubstitutions;
        private AndroidPushNotificationTemplate gcm;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(PushNotificationTemplateRequest model) {
            this.adm(model.adm);
            this.apns(model.apns);
            this.baidu(model.baidu);
            this.defaultValue(model.defaultValue);
            this.defaultSubstitutions(model.defaultSubstitutions);
            this.gcm(model.gcm);
            this.tags(model.tags);
            this.templateDescription(model.templateDescription);
        }

        public final AndroidPushNotificationTemplate.Builder getAdm() {
            return this.adm != null ? this.adm.toBuilder() : null;
        }

        @Override
        public final Builder adm(AndroidPushNotificationTemplate adm) {
            this.adm = adm;
            return this;
        }

        public final void setAdm(AndroidPushNotificationTemplate.BuilderImpl adm) {
            this.adm = adm != null ? adm.build() : null;
        }

        public final APNSPushNotificationTemplate.Builder getApns() {
            return this.apns != null ? this.apns.toBuilder() : null;
        }

        @Override
        public final Builder apns(APNSPushNotificationTemplate apns) {
            this.apns = apns;
            return this;
        }

        public final void setApns(APNSPushNotificationTemplate.BuilderImpl apns) {
            this.apns = apns != null ? apns.build() : null;
        }

        public final AndroidPushNotificationTemplate.Builder getBaidu() {
            return this.baidu != null ? this.baidu.toBuilder() : null;
        }

        @Override
        public final Builder baidu(AndroidPushNotificationTemplate baidu) {
            this.baidu = baidu;
            return this;
        }

        public final void setBaidu(AndroidPushNotificationTemplate.BuilderImpl baidu) {
            this.baidu = baidu != null ? baidu.build() : null;
        }

        public final DefaultPushNotificationTemplate.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        @Override
        public final Builder defaultValue(DefaultPushNotificationTemplate defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(DefaultPushNotificationTemplate.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        public final String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        public final AndroidPushNotificationTemplate.Builder getGcm() {
            return this.gcm != null ? this.gcm.toBuilder() : null;
        }

        @Override
        public final Builder gcm(AndroidPushNotificationTemplate gcm) {
            this.gcm = gcm;
            return this;
        }

        public final void setGcm(AndroidPushNotificationTemplate.BuilderImpl gcm) {
            this.gcm = gcm != null ? gcm.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public PushNotificationTemplateRequest build() {
            return new PushNotificationTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushNotificationTemplateRequest> {
        public Builder adm(AndroidPushNotificationTemplate var1);

        default public Builder adm(Consumer<AndroidPushNotificationTemplate.Builder> adm) {
            return this.adm((AndroidPushNotificationTemplate)((AndroidPushNotificationTemplate.Builder)AndroidPushNotificationTemplate.builder().applyMutation(adm)).build());
        }

        public Builder apns(APNSPushNotificationTemplate var1);

        default public Builder apns(Consumer<APNSPushNotificationTemplate.Builder> apns) {
            return this.apns((APNSPushNotificationTemplate)((APNSPushNotificationTemplate.Builder)APNSPushNotificationTemplate.builder().applyMutation(apns)).build());
        }

        public Builder baidu(AndroidPushNotificationTemplate var1);

        default public Builder baidu(Consumer<AndroidPushNotificationTemplate.Builder> baidu) {
            return this.baidu((AndroidPushNotificationTemplate)((AndroidPushNotificationTemplate.Builder)AndroidPushNotificationTemplate.builder().applyMutation(baidu)).build());
        }

        public Builder defaultValue(DefaultPushNotificationTemplate var1);

        default public Builder defaultValue(Consumer<DefaultPushNotificationTemplate.Builder> defaultValue) {
            return this.defaultValue((DefaultPushNotificationTemplate)((DefaultPushNotificationTemplate.Builder)DefaultPushNotificationTemplate.builder().applyMutation(defaultValue)).build());
        }

        public Builder defaultSubstitutions(String var1);

        public Builder gcm(AndroidPushNotificationTemplate var1);

        default public Builder gcm(Consumer<AndroidPushNotificationTemplate.Builder> gcm) {
            return this.gcm((AndroidPushNotificationTemplate)((AndroidPushNotificationTemplate.Builder)AndroidPushNotificationTemplate.builder().applyMutation(gcm)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder templateDescription(String var1);
    }
}

