/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJourneyStateRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateJourneyStateRequest.Builder, UpdateJourneyStateRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJourneyStateRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJourneyStateRequest::journeyId)).setter(setter(Builder::journeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("journey-id").build()).build();

    private static final SdkField<JourneyStateRequest> JOURNEY_STATE_REQUEST_FIELD = SdkField
            .<JourneyStateRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateJourneyStateRequest::journeyStateRequest))
            .setter(setter(Builder::journeyStateRequest))
            .constructor(JourneyStateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyStateRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            JOURNEY_ID_FIELD, JOURNEY_STATE_REQUEST_FIELD));

    private final String applicationId;

    private final String journeyId;

    private final JourneyStateRequest journeyStateRequest;

    private UpdateJourneyStateRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.journeyId = builder.journeyId;
        this.journeyStateRequest = builder.journeyStateRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the journey.
     * </p>
     * 
     * @return The unique identifier for the journey.
     */
    public String journeyId() {
        return journeyId;
    }

    /**
     * Returns the value of the JourneyStateRequest property for this object.
     * 
     * @return The value of the JourneyStateRequest property for this object.
     */
    public JourneyStateRequest journeyStateRequest() {
        return journeyStateRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(journeyStateRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJourneyStateRequest)) {
            return false;
        }
        UpdateJourneyStateRequest other = (UpdateJourneyStateRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(journeyId(), other.journeyId())
                && Objects.equals(journeyStateRequest(), other.journeyStateRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateJourneyStateRequest").add("ApplicationId", applicationId()).add("JourneyId", journeyId())
                .add("JourneyStateRequest", journeyStateRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "JourneyId":
            return Optional.ofNullable(clazz.cast(journeyId()));
        case "JourneyStateRequest":
            return Optional.ofNullable(clazz.cast(journeyStateRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJourneyStateRequest, T> g) {
        return obj -> g.apply((UpdateJourneyStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJourneyStateRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the journey.
         * </p>
         * 
         * @param journeyId
         *        The unique identifier for the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyId(String journeyId);

        /**
         * Sets the value of the JourneyStateRequest property for this object.
         *
         * @param journeyStateRequest
         *        The new value for the JourneyStateRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyStateRequest(JourneyStateRequest journeyStateRequest);

        /**
         * Sets the value of the JourneyStateRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link JourneyStateRequest.Builder} avoiding the need
         * to create one manually via {@link JourneyStateRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link JourneyStateRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #journeyStateRequest(JourneyStateRequest)}.
         * 
         * @param journeyStateRequest
         *        a consumer that will call methods on {@link JourneyStateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journeyStateRequest(JourneyStateRequest)
         */
        default Builder journeyStateRequest(Consumer<JourneyStateRequest.Builder> journeyStateRequest) {
            return journeyStateRequest(JourneyStateRequest.builder().applyMutation(journeyStateRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String journeyId;

        private JourneyStateRequest journeyStateRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJourneyStateRequest model) {
            super(model);
            applicationId(model.applicationId);
            journeyId(model.journeyId);
            journeyStateRequest(model.journeyStateRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getJourneyId() {
            return journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        public final JourneyStateRequest.Builder getJourneyStateRequest() {
            return journeyStateRequest != null ? journeyStateRequest.toBuilder() : null;
        }

        @Override
        public final Builder journeyStateRequest(JourneyStateRequest journeyStateRequest) {
            this.journeyStateRequest = journeyStateRequest;
            return this;
        }

        public final void setJourneyStateRequest(JourneyStateRequest.BuilderImpl journeyStateRequest) {
            this.journeyStateRequest = journeyStateRequest != null ? journeyStateRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJourneyStateRequest build() {
            return new UpdateJourneyStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
