/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies criteria for including or excluding endpoints from a segment based on how recently an endpoint was active.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecencyDimension implements SdkPojo, Serializable,
        ToCopyableBuilder<RecencyDimension.Builder, RecencyDimension> {
    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecencyDimension::durationAsString)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> RECENCY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecencyDimension::recencyTypeAsString)).setter(setter(Builder::recencyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecencyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD,
            RECENCY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String duration;

    private final String recencyType;

    private RecencyDimension(BuilderImpl builder) {
        this.duration = builder.duration;
        this.recencyType = builder.recencyType;
    }

    /**
     * <p>
     * The duration to use when determining whether an endpoint is active or inactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #duration} will
     * return {@link Duration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationAsString}.
     * </p>
     * 
     * @return The duration to use when determining whether an endpoint is active or inactive.
     * @see Duration
     */
    public Duration duration() {
        return Duration.fromValue(duration);
    }

    /**
     * <p>
     * The duration to use when determining whether an endpoint is active or inactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #duration} will
     * return {@link Duration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationAsString}.
     * </p>
     * 
     * @return The duration to use when determining whether an endpoint is active or inactive.
     * @see Duration
     */
    public String durationAsString() {
        return duration;
    }

    /**
     * <p>
     * The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active within
     * the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active within the
     * specified duration are included in the segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recencyType} will
     * return {@link RecencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recencyTypeAsString}.
     * </p>
     * 
     * @return The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were
     *         active within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't
     *         active within the specified duration are included in the segment.
     * @see RecencyType
     */
    public RecencyType recencyType() {
        return RecencyType.fromValue(recencyType);
    }

    /**
     * <p>
     * The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active within
     * the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active within the
     * specified duration are included in the segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recencyType} will
     * return {@link RecencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recencyTypeAsString}.
     * </p>
     * 
     * @return The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were
     *         active within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't
     *         active within the specified duration are included in the segment.
     * @see RecencyType
     */
    public String recencyTypeAsString() {
        return recencyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recencyTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecencyDimension)) {
            return false;
        }
        RecencyDimension other = (RecencyDimension) obj;
        return Objects.equals(durationAsString(), other.durationAsString())
                && Objects.equals(recencyTypeAsString(), other.recencyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecencyDimension").add("Duration", durationAsString()).add("RecencyType", recencyTypeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(durationAsString()));
        case "RecencyType":
            return Optional.ofNullable(clazz.cast(recencyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecencyDimension, T> g) {
        return obj -> g.apply((RecencyDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecencyDimension> {
        /**
         * <p>
         * The duration to use when determining whether an endpoint is active or inactive.
         * </p>
         * 
         * @param duration
         *        The duration to use when determining whether an endpoint is active or inactive.
         * @see Duration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Duration
         */
        Builder duration(String duration);

        /**
         * <p>
         * The duration to use when determining whether an endpoint is active or inactive.
         * </p>
         * 
         * @param duration
         *        The duration to use when determining whether an endpoint is active or inactive.
         * @see Duration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Duration
         */
        Builder duration(Duration duration);

        /**
         * <p>
         * The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active
         * within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active
         * within the specified duration are included in the segment.
         * </p>
         * 
         * @param recencyType
         *        The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were
         *        active within the specified duration are included in the segment; and, INACTIVE, endpoints that
         *        weren't active within the specified duration are included in the segment.
         * @see RecencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecencyType
         */
        Builder recencyType(String recencyType);

        /**
         * <p>
         * The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active
         * within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active
         * within the specified duration are included in the segment.
         * </p>
         * 
         * @param recencyType
         *        The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were
         *        active within the specified duration are included in the segment; and, INACTIVE, endpoints that
         *        weren't active within the specified duration are included in the segment.
         * @see RecencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecencyType
         */
        Builder recencyType(RecencyType recencyType);
    }

    static final class BuilderImpl implements Builder {
        private String duration;

        private String recencyType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecencyDimension model) {
            duration(model.duration);
            recencyType(model.recencyType);
        }

        public final String getDurationAsString() {
            return duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public final Builder duration(Duration duration) {
            this.duration(duration == null ? null : duration.toString());
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getRecencyTypeAsString() {
            return recencyType;
        }

        @Override
        public final Builder recencyType(String recencyType) {
            this.recencyType = recencyType;
            return this;
        }

        @Override
        public final Builder recencyType(RecencyType recencyType) {
            this.recencyType(recencyType == null ? null : recencyType.toString());
            return this;
        }

        public final void setRecencyType(String recencyType) {
            this.recencyType = recencyType;
        }

        @Override
        public RecencyDimension build() {
            return new RecencyDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
