/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a batch of events to process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventsRequest implements SdkPojo, Serializable, ToCopyableBuilder<EventsRequest.Builder, EventsRequest> {
    private static final SdkField<Map<String, EventsBatch>> BATCH_ITEM_FIELD = SdkField
            .<Map<String, EventsBatch>> builder(MarshallingType.MAP)
            .getter(getter(EventsRequest::batchItem))
            .setter(setter(Builder::batchItem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchItem").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EventsBatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventsBatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, EventsBatch> batchItem;

    private EventsRequest(BuilderImpl builder) {
        this.batchItem = builder.batchItem;
    }

    /**
     * Returns true if the BatchItem property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBatchItem() {
        return batchItem != null && !(batchItem instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The batch of events to process. For each item in a batch, the endpoint ID acts as a key that has an EventsBatch
     * object as its value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBatchItem()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The batch of events to process. For each item in a batch, the endpoint ID acts as a key that has an
     *         EventsBatch object as its value.
     */
    public Map<String, EventsBatch> batchItem() {
        return batchItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchItem());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsRequest)) {
            return false;
        }
        EventsRequest other = (EventsRequest) obj;
        return Objects.equals(batchItem(), other.batchItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventsRequest").add("BatchItem", batchItem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchItem":
            return Optional.ofNullable(clazz.cast(batchItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsRequest, T> g) {
        return obj -> g.apply((EventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventsRequest> {
        /**
         * <p>
         * The batch of events to process. For each item in a batch, the endpoint ID acts as a key that has an
         * EventsBatch object as its value.
         * </p>
         * 
         * @param batchItem
         *        The batch of events to process. For each item in a batch, the endpoint ID acts as a key that has an
         *        EventsBatch object as its value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchItem(Map<String, EventsBatch> batchItem);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, EventsBatch> batchItem = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsRequest model) {
            batchItem(model.batchItem);
        }

        public final Map<String, EventsBatch.Builder> getBatchItem() {
            return batchItem != null ? CollectionUtils.mapValues(batchItem, EventsBatch::toBuilder) : null;
        }

        @Override
        public final Builder batchItem(Map<String, EventsBatch> batchItem) {
            this.batchItem = MapOfEventsBatchCopier.copy(batchItem);
            return this;
        }

        public final void setBatchItem(Map<String, EventsBatch.BuilderImpl> batchItem) {
            this.batchItem = MapOfEventsBatchCopier.copyFromBuilder(batchItem);
        }

        @Override
        public EventsRequest build() {
            return new EventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
