/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.CampaignHook;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.ListOfWriteTreatmentResourceCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration;
import software.amazon.awssdk.services.pinpoint.model.WriteTreatmentResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteCampaignRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteCampaignRequest> {
    private static final SdkField<List<WriteTreatmentResource>> ADDITIONAL_TREATMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(WriteCampaignRequest.getter(WriteCampaignRequest::additionalTreatments)).setter(WriteCampaignRequest.setter(Builder::additionalTreatments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalTreatments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WriteTreatmentResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WriteCampaignRequest.getter(WriteCampaignRequest::description)).setter(WriteCampaignRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> HOLDOUT_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(WriteCampaignRequest.getter(WriteCampaignRequest::holdoutPercent)).setter(WriteCampaignRequest.setter(Builder::holdoutPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoldoutPercent").build()}).build();
    private static final SdkField<CampaignHook> HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteCampaignRequest.getter(WriteCampaignRequest::hook)).setter(WriteCampaignRequest.setter(Builder::hook)).constructor(CampaignHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hook").build()}).build();
    private static final SdkField<Boolean> IS_PAUSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WriteCampaignRequest.getter(WriteCampaignRequest::isPaused)).setter(WriteCampaignRequest.setter(Builder::isPaused)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPaused").build()}).build();
    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteCampaignRequest.getter(WriteCampaignRequest::limits)).setter(WriteCampaignRequest.setter(Builder::limits)).constructor(CampaignLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()}).build();
    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteCampaignRequest.getter(WriteCampaignRequest::messageConfiguration)).setter(WriteCampaignRequest.setter(Builder::messageConfiguration)).constructor(MessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WriteCampaignRequest.getter(WriteCampaignRequest::name)).setter(WriteCampaignRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteCampaignRequest.getter(WriteCampaignRequest::schedule)).setter(WriteCampaignRequest.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WriteCampaignRequest.getter(WriteCampaignRequest::segmentId)).setter(WriteCampaignRequest.setter(Builder::segmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()}).build();
    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(WriteCampaignRequest.getter(WriteCampaignRequest::segmentVersion)).setter(WriteCampaignRequest.setter(Builder::segmentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(WriteCampaignRequest.getter(WriteCampaignRequest::tags)).setter(WriteCampaignRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteCampaignRequest.getter(WriteCampaignRequest::templateConfiguration)).setter(WriteCampaignRequest.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WriteCampaignRequest.getter(WriteCampaignRequest::treatmentDescription)).setter(WriteCampaignRequest.setter(Builder::treatmentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build()}).build();
    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WriteCampaignRequest.getter(WriteCampaignRequest::treatmentName)).setter(WriteCampaignRequest.setter(Builder::treatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TREATMENTS_FIELD, DESCRIPTION_FIELD, HOLDOUT_PERCENT_FIELD, HOOK_FIELD, IS_PAUSED_FIELD, LIMITS_FIELD, MESSAGE_CONFIGURATION_FIELD, NAME_FIELD, SCHEDULE_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD, TAGS_FIELD, TEMPLATE_CONFIGURATION_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<WriteTreatmentResource> additionalTreatments;
    private final String description;
    private final Integer holdoutPercent;
    private final CampaignHook hook;
    private final Boolean isPaused;
    private final CampaignLimits limits;
    private final MessageConfiguration messageConfiguration;
    private final String name;
    private final Schedule schedule;
    private final String segmentId;
    private final Integer segmentVersion;
    private final Map<String, String> tags;
    private final TemplateConfiguration templateConfiguration;
    private final String treatmentDescription;
    private final String treatmentName;

    private WriteCampaignRequest(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.hook = builder.hook;
        this.isPaused = builder.isPaused;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.tags = builder.tags;
        this.templateConfiguration = builder.templateConfiguration;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    public List<WriteTreatmentResource> additionalTreatments() {
        return this.additionalTreatments;
    }

    public String description() {
        return this.description;
    }

    public Integer holdoutPercent() {
        return this.holdoutPercent;
    }

    public CampaignHook hook() {
        return this.hook;
    }

    public Boolean isPaused() {
        return this.isPaused;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public String name() {
        return this.name;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public Integer segmentVersion() {
        return this.segmentVersion;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalTreatments());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hook());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteCampaignRequest)) {
            return false;
        }
        WriteCampaignRequest other = (WriteCampaignRequest)obj;
        return Objects.equals(this.additionalTreatments(), other.additionalTreatments()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.holdoutPercent(), other.holdoutPercent()) && Objects.equals(this.hook(), other.hook()) && Objects.equals(this.isPaused(), other.isPaused()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentVersion(), other.segmentVersion()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.treatmentDescription(), other.treatmentDescription()) && Objects.equals(this.treatmentName(), other.treatmentName());
    }

    public String toString() {
        return ToString.builder((String)"WriteCampaignRequest").add("AdditionalTreatments", this.additionalTreatments()).add("Description", (Object)this.description()).add("HoldoutPercent", (Object)this.holdoutPercent()).add("Hook", (Object)this.hook()).add("IsPaused", (Object)this.isPaused()).add("Limits", (Object)this.limits()).add("MessageConfiguration", (Object)this.messageConfiguration()).add("Name", (Object)this.name()).add("Schedule", (Object)this.schedule()).add("SegmentId", (Object)this.segmentId()).add("SegmentVersion", (Object)this.segmentVersion()).add("Tags", this.tags()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TreatmentDescription", (Object)this.treatmentDescription()).add("TreatmentName", (Object)this.treatmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalTreatments": {
                return Optional.ofNullable(clazz.cast(this.additionalTreatments()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HoldoutPercent": {
                return Optional.ofNullable(clazz.cast(this.holdoutPercent()));
            }
            case "Hook": {
                return Optional.ofNullable(clazz.cast(this.hook()));
            }
            case "IsPaused": {
                return Optional.ofNullable(clazz.cast(this.isPaused()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.ofNullable(clazz.cast(this.segmentVersion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "TreatmentDescription": {
                return Optional.ofNullable(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteCampaignRequest, T> g) {
        return obj -> g.apply((WriteCampaignRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WriteTreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Integer holdoutPercent;
        private CampaignHook hook;
        private Boolean isPaused;
        private CampaignLimits limits;
        private MessageConfiguration messageConfiguration;
        private String name;
        private Schedule schedule;
        private String segmentId;
        private Integer segmentVersion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private TemplateConfiguration templateConfiguration;
        private String treatmentDescription;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteCampaignRequest model) {
            this.additionalTreatments(model.additionalTreatments);
            this.description(model.description);
            this.holdoutPercent(model.holdoutPercent);
            this.hook(model.hook);
            this.isPaused(model.isPaused);
            this.limits(model.limits);
            this.messageConfiguration(model.messageConfiguration);
            this.name(model.name);
            this.schedule(model.schedule);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
            this.tags(model.tags);
            this.templateConfiguration(model.templateConfiguration);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
        }

        public final Collection<WriteTreatmentResource.Builder> getAdditionalTreatments() {
            return this.additionalTreatments != null ? (Collection)this.additionalTreatments.stream().map(WriteTreatmentResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalTreatments(Collection<WriteTreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(WriteTreatmentResource ... additionalTreatments) {
            this.additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder> ... additionalTreatments) {
            this.additionalTreatments(Stream.of(additionalTreatments).map(c -> (WriteTreatmentResource)((WriteTreatmentResource.Builder)WriteTreatmentResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalTreatments(Collection<WriteTreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getHoldoutPercent() {
            return this.holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        public final CampaignHook.Builder getHook() {
            return this.hook != null ? this.hook.toBuilder() : null;
        }

        @Override
        public final Builder hook(CampaignHook hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(CampaignHook.BuilderImpl hook) {
            this.hook = hook != null ? hook.build() : null;
        }

        public final Boolean getIsPaused() {
            return this.isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public WriteCampaignRequest build() {
            return new WriteCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteCampaignRequest> {
        public Builder additionalTreatments(Collection<WriteTreatmentResource> var1);

        public Builder additionalTreatments(WriteTreatmentResource ... var1);

        public Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder> ... var1);

        public Builder description(String var1);

        public Builder holdoutPercent(Integer var1);

        public Builder hook(CampaignHook var1);

        default public Builder hook(Consumer<CampaignHook.Builder> hook) {
            return this.hook((CampaignHook)((CampaignHook.Builder)CampaignHook.builder().applyMutation(hook)).build());
        }

        public Builder isPaused(Boolean var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().applyMutation(limits)).build());
        }

        public Builder messageConfiguration(MessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);
    }
}

