/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QuietTimeMarshaller {
    private static final MarshallingInfo<String> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("End").isBinary(false).build();
    private static final MarshallingInfo<String> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Start").isBinary(false).build();
    private static final QuietTimeMarshaller INSTANCE = new QuietTimeMarshaller();

    private QuietTimeMarshaller() {
    }

    public static QuietTimeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QuietTime quietTime, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)quietTime, (String)"quietTime");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)quietTime.end(), END_BINDING);
            protocolMarshaller.marshall((Object)quietTime.start(), START_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

