/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointBatchItemMarshaller {
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<String> CHANNELTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEMOGRAPHIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Demographic").isBinary(false).build();
    private static final MarshallingInfo<String> EFFECTIVEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EffectiveDate").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointStatus").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").isBinary(false).build();
    private static final MarshallingInfo<Map> METRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metrics").isBinary(false).build();
    private static final MarshallingInfo<String> OPTOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OptOut").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> USER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("User").isBinary(false).build();
    private static final EndpointBatchItemMarshaller INSTANCE = new EndpointBatchItemMarshaller();

    private EndpointBatchItemMarshaller() {
    }

    public static EndpointBatchItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointBatchItem endpointBatchItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointBatchItem, (String)"endpointBatchItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpointBatchItem.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall(endpointBatchItem.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.channelTypeString(), CHANNELTYPE_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.demographic(), DEMOGRAPHIC_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.effectiveDate(), EFFECTIVEDATE_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.endpointStatus(), ENDPOINTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(endpointBatchItem.metrics(), METRICS_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.optOut(), OPTOUT_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.requestId(), REQUESTID_BINDING);
            protocolMarshaller.marshall((Object)endpointBatchItem.user(), USER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

