/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignState;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.transform.TreatmentResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TreatmentResource
implements StructuredPojo,
ToCopyableBuilder<Builder, TreatmentResource> {
    private final String id;
    private final MessageConfiguration messageConfiguration;
    private final Schedule schedule;
    private final Integer sizePercent;
    private final CampaignState state;
    private final String treatmentDescription;
    private final String treatmentName;

    private TreatmentResource(BuilderImpl builder) {
        this.id = builder.id;
        this.messageConfiguration = builder.messageConfiguration;
        this.schedule = builder.schedule;
        this.sizePercent = builder.sizePercent;
        this.state = builder.state;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    public String id() {
        return this.id;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public Integer sizePercent() {
        return this.sizePercent;
    }

    public CampaignState state() {
        return this.state;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreatmentResource)) {
            return false;
        }
        TreatmentResource other = (TreatmentResource)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.sizePercent(), other.sizePercent()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.treatmentDescription(), other.treatmentDescription()) && Objects.equals(this.treatmentName(), other.treatmentName());
    }

    public String toString() {
        return ToString.builder((String)"TreatmentResource").add("Id", (Object)this.id()).add("MessageConfiguration", (Object)this.messageConfiguration()).add("Schedule", (Object)this.schedule()).add("SizePercent", (Object)this.sizePercent()).add("State", (Object)this.state()).add("TreatmentDescription", (Object)this.treatmentDescription()).add("TreatmentName", (Object)this.treatmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "MessageConfiguration": {
                return Optional.of(clazz.cast(this.messageConfiguration()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "SizePercent": {
                return Optional.of(clazz.cast(this.sizePercent()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "TreatmentDescription": {
                return Optional.of(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.of(clazz.cast(this.treatmentName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TreatmentResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private MessageConfiguration messageConfiguration;
        private Schedule schedule;
        private Integer sizePercent;
        private CampaignState state;
        private String treatmentDescription;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(TreatmentResource model) {
            this.id(model.id);
            this.messageConfiguration(model.messageConfiguration);
            this.schedule(model.schedule);
            this.sizePercent(model.sizePercent);
            this.state(model.state);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final Integer getSizePercent() {
            return this.sizePercent;
        }

        @Override
        public final Builder sizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
            return this;
        }

        public final void setSizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
        }

        public final CampaignState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final void setState(CampaignState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public TreatmentResource build() {
            return new TreatmentResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TreatmentResource> {
        public Builder id(String var1);

        public Builder messageConfiguration(MessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().apply(messageConfiguration)).build());
        }

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().apply(schedule)).build());
        }

        public Builder sizePercent(Integer var1);

        public Builder state(CampaignState var1);

        default public Builder state(Consumer<CampaignState.Builder> state) {
            return this.state((CampaignState)((CampaignState.Builder)CampaignState.builder().apply(state)).build());
        }

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);
    }
}

