/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult;

@SdkInternalApi
public class EndpointMessageResultMarshaller {
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").build();
    private static final MarshallingInfo<String> DELIVERYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStatus").build();
    private static final MarshallingInfo<Integer> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<String> UPDATEDTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedToken").build();
    private static final EndpointMessageResultMarshaller INSTANCE = new EndpointMessageResultMarshaller();

    public static EndpointMessageResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointMessageResult endpointMessageResult, ProtocolMarshaller protocolMarshaller) {
        if (endpointMessageResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpointMessageResult.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)endpointMessageResult.deliveryStatusString(), DELIVERYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)endpointMessageResult.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)endpointMessageResult.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)endpointMessageResult.updatedToken(), UPDATEDTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

