/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.BaiduMessage;

public class BaiduMessageUnmarshaller
implements Unmarshaller<BaiduMessage, JsonUnmarshallerContext> {
    private static final BaiduMessageUnmarshaller INSTANCE = new BaiduMessageUnmarshaller();

    public BaiduMessage unmarshall(JsonUnmarshallerContext context) throws Exception {
        BaiduMessage.Builder baiduMessageBuilder = BaiduMessage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.action((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.body((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.data(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("IconReference", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.iconReference((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageIconUrl", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.imageIconUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageUrl", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.imageUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RawContent", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.rawContent((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SilentPush", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.silentPush((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("SmallImageIconUrl", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.smallImageIconUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Sound", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.sound((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.substitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.title((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Url", targetDepth)) {
                    context.nextToken();
                    baiduMessageBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BaiduMessage)baiduMessageBuilder.build();
    }

    public static BaiduMessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

