/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.AddressConfiguration;
import software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration;
import software.amazon.awssdk.services.pinpoint.model.MapOfAddressConfigurationCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOfEndpointSendConfigurationCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.MessageRequestMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageRequest> {
    private final Map<String, AddressConfiguration> addresses;
    private final Map<String, String> context;
    private final Map<String, EndpointSendConfiguration> endpoints;
    private final DirectMessageConfiguration messageConfiguration;

    private MessageRequest(BuilderImpl builder) {
        this.addresses = builder.addresses;
        this.context = builder.context;
        this.endpoints = builder.endpoints;
        this.messageConfiguration = builder.messageConfiguration;
    }

    public Map<String, AddressConfiguration> addresses() {
        return this.addresses;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public Map<String, EndpointSendConfiguration> endpoints() {
        return this.endpoints;
    }

    public DirectMessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageRequest)) {
            return false;
        }
        MessageRequest other = (MessageRequest)obj;
        return Objects.equals(this.addresses(), other.addresses()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"MessageRequest").add("Addresses", this.addresses()).add("Context", this.context()).add("Endpoints", this.endpoints()).add("MessageConfiguration", (Object)this.messageConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Addresses": {
                return Optional.of(clazz.cast(this.addresses()));
            }
            case "Context": {
                return Optional.of(clazz.cast(this.context()));
            }
            case "Endpoints": {
                return Optional.of(clazz.cast(this.endpoints()));
            }
            case "MessageConfiguration": {
                return Optional.of(clazz.cast(this.messageConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AddressConfiguration> addresses;
        private Map<String, String> context;
        private Map<String, EndpointSendConfiguration> endpoints;
        private DirectMessageConfiguration messageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageRequest model) {
            this.addresses(model.addresses);
            this.context(model.context);
            this.endpoints(model.endpoints);
            this.messageConfiguration(model.messageConfiguration);
        }

        public final Map<String, AddressConfiguration.Builder> getAddresses() {
            return this.addresses != null ? CollectionUtils.mapValues(this.addresses, AddressConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder addresses(Map<String, AddressConfiguration> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copy(addresses);
            return this;
        }

        public final void setAddresses(Map<String, AddressConfiguration.BuilderImpl> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copyFromBuilder(addresses);
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final Map<String, EndpointSendConfiguration.Builder> getEndpoints() {
            return this.endpoints != null ? CollectionUtils.mapValues(this.endpoints, EndpointSendConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder endpoints(Map<String, EndpointSendConfiguration> endpoints) {
            this.endpoints = MapOfEndpointSendConfigurationCopier.copy(endpoints);
            return this;
        }

        public final void setEndpoints(Map<String, EndpointSendConfiguration.BuilderImpl> endpoints) {
            this.endpoints = MapOfEndpointSendConfigurationCopier.copyFromBuilder(endpoints);
        }

        public final DirectMessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(DirectMessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public MessageRequest build() {
            return new MessageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageRequest> {
        public Builder addresses(Map<String, AddressConfiguration> var1);

        public Builder context(Map<String, String> var1);

        public Builder endpoints(Map<String, EndpointSendConfiguration> var1);

        public Builder messageConfiguration(DirectMessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<DirectMessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((DirectMessageConfiguration)((DirectMessageConfiguration.Builder)DirectMessageConfiguration.builder().apply(messageConfiguration)).build());
        }
    }
}

