/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.TreatmentResource;

@SdkInternalApi
public class TreatmentResourceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<StructuredPojo> MESSAGECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schedule").build();
    private static final MarshallingInfo<Integer> SIZEPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizePercent").build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> TREATMENTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentDescription").build();
    private static final MarshallingInfo<String> TREATMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentName").build();
    private static final TreatmentResourceMarshaller INSTANCE = new TreatmentResourceMarshaller();

    public static TreatmentResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TreatmentResource treatmentResource, ProtocolMarshaller protocolMarshaller) {
        if (treatmentResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)treatmentResource.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.messageConfiguration(), MESSAGECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.schedule(), SCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.sizePercent(), SIZEPERCENT_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.treatmentDescription(), TREATMENTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.treatmentName(), TREATMENTNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

