/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest;

@SdkInternalApi
public class SMSChannelRequestMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> SENDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SenderId").build();
    private static final MarshallingInfo<String> SHORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShortCode").build();
    private static final SMSChannelRequestMarshaller INSTANCE = new SMSChannelRequestMarshaller();

    public static SMSChannelRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SMSChannelRequest smsChannelRequest, ProtocolMarshaller protocolMarshaller) {
        if (smsChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)smsChannelRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)smsChannelRequest.senderId(), SENDERID_BINDING);
            protocolMarshaller.marshall((Object)smsChannelRequest.shortCode(), SHORTCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

