/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.RecencyDimension;

@SdkInternalApi
public class RecencyDimensionMarshaller {
    private static final MarshallingInfo<String> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").build();
    private static final MarshallingInfo<String> RECENCYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecencyType").build();
    private static final RecencyDimensionMarshaller INSTANCE = new RecencyDimensionMarshaller();

    public static RecencyDimensionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecencyDimension recencyDimension, ProtocolMarshaller protocolMarshaller) {
        if (recencyDimension == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recencyDimension.durationString(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)recencyDimension.recencyTypeString(), RECENCYTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

