/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.GCMMessage;

@SdkInternalApi
public class GCMMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<String> COLLAPSEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollapseKey").build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<String> ICONREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IconReference").build();
    private static final MarshallingInfo<String> IMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageIconUrl").build();
    private static final MarshallingInfo<String> IMAGEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageUrl").build();
    private static final MarshallingInfo<String> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").build();
    private static final MarshallingInfo<String> RESTRICTEDPACKAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RestrictedPackageName").build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").build();
    private static final MarshallingInfo<String> SMALLIMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmallImageIconUrl").build();
    private static final MarshallingInfo<String> SOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sound").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<Integer> TIMETOLIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeToLive").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final GCMMessageMarshaller INSTANCE = new GCMMessageMarshaller();

    public static GCMMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GCMMessage gcmMessage, ProtocolMarshaller protocolMarshaller) {
        if (gcmMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)gcmMessage.actionString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.collapseKey(), COLLAPSEKEY_BINDING);
            protocolMarshaller.marshall(gcmMessage.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.iconReference(), ICONREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.imageIconUrl(), IMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.imageUrl(), IMAGEURL_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.rawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.restrictedPackageName(), RESTRICTEDPACKAGENAME_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.silentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.smallImageIconUrl(), SMALLIMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.sound(), SOUND_BINDING);
            protocolMarshaller.marshall(gcmMessage.substitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.timeToLive(), TIMETOLIVE_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)gcmMessage.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

