/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.AddressConfiguration;

@SdkInternalApi
public class AddressConfigurationMarshaller {
    private static final MarshallingInfo<String> BODYOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BodyOverride").build();
    private static final MarshallingInfo<String> CHANNELTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelType").build();
    private static final MarshallingInfo<Map> CONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Context").build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> TITLEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TitleOverride").build();
    private static final AddressConfigurationMarshaller INSTANCE = new AddressConfigurationMarshaller();

    public static AddressConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AddressConfiguration addressConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (addressConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)addressConfiguration.bodyOverride(), BODYOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)addressConfiguration.channelTypeString(), CHANNELTYPE_BINDING);
            protocolMarshaller.marshall(addressConfiguration.context(), CONTEXT_BINDING);
            protocolMarshaller.marshall((Object)addressConfiguration.rawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall(addressConfiguration.substitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)addressConfiguration.titleOverride(), TITLEOVERRIDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

