/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.transform.WriteApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WriteApplicationSettingsRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteApplicationSettingsRequest> {
    private final CampaignLimits limits;
    private final QuietTime quietTime;

    private WriteApplicationSettingsRequest(BuilderImpl builder) {
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.quietTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteApplicationSettingsRequest)) {
            return false;
        }
        WriteApplicationSettingsRequest other = (WriteApplicationSettingsRequest)obj;
        return Objects.equals(this.limits(), other.limits()) && Objects.equals(this.quietTime(), other.quietTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.limits() != null) {
            sb.append("Limits: ").append(this.limits()).append(",");
        }
        if (this.quietTime() != null) {
            sb.append("QuietTime: ").append(this.quietTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limits": {
                return Optional.of(clazz.cast(this.limits()));
            }
            case "QuietTime": {
                return Optional.of(clazz.cast(this.quietTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteApplicationSettingsRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private CampaignLimits limits;
        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteApplicationSettingsRequest model) {
            this.limits(model.limits);
            this.quietTime(model.quietTime);
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public WriteApplicationSettingsRequest build() {
            return new WriteApplicationSettingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteApplicationSettingsRequest> {
        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().apply(limits)).build());
        }

        public Builder quietTime(QuietTime var1);

        default public Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return this.quietTime((QuietTime)((QuietTime.Builder)QuietTime.builder().apply(quietTime)).build());
        }
    }
}

