/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateBaiduChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateBaiduChannelRequest> {
    private final String applicationId;
    private final BaiduChannelRequest baiduChannelRequest;

    private UpdateBaiduChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.baiduChannelRequest = builder.baiduChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public BaiduChannelRequest baiduChannelRequest() {
        return this.baiduChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baiduChannelRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBaiduChannelRequest)) {
            return false;
        }
        UpdateBaiduChannelRequest other = (UpdateBaiduChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.baiduChannelRequest(), other.baiduChannelRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.baiduChannelRequest() != null) {
            sb.append("BaiduChannelRequest: ").append(this.baiduChannelRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "BaiduChannelRequest": {
                return Optional.of(clazz.cast(this.baiduChannelRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private BaiduChannelRequest baiduChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBaiduChannelRequest model) {
            this.applicationId(model.applicationId);
            this.baiduChannelRequest(model.baiduChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final BaiduChannelRequest.Builder getBaiduChannelRequest() {
            return this.baiduChannelRequest != null ? this.baiduChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder baiduChannelRequest(BaiduChannelRequest baiduChannelRequest) {
            this.baiduChannelRequest = baiduChannelRequest;
            return this;
        }

        public final void setBaiduChannelRequest(BaiduChannelRequest.BuilderImpl baiduChannelRequest) {
            this.baiduChannelRequest = baiduChannelRequest != null ? baiduChannelRequest.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateBaiduChannelRequest build() {
            return new UpdateBaiduChannelRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateBaiduChannelRequest> {
        public Builder applicationId(String var1);

        public Builder baiduChannelRequest(BaiduChannelRequest var1);

        default public Builder baiduChannelRequest(Consumer<BaiduChannelRequest.Builder> baiduChannelRequest) {
            return this.baiduChannelRequest((BaiduChannelRequest)((BaiduChannelRequest.Builder)BaiduChannelRequest.builder().apply(baiduChannelRequest)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

