/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.model.SegmentImportResource;
import software.amazon.awssdk.services.pinpoint.model.SegmentType;
import software.amazon.awssdk.services.pinpoint.transform.SegmentResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SegmentResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentResponse> {
    private final String applicationId;
    private final String creationDate;
    private final SegmentDimensions dimensions;
    private final String id;
    private final SegmentImportResource importDefinition;
    private final String lastModifiedDate;
    private final String name;
    private final String segmentType;
    private final Integer version;

    private SegmentResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.dimensions = builder.dimensions;
        this.id = builder.id;
        this.importDefinition = builder.importDefinition;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.segmentType = builder.segmentType;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public SegmentDimensions dimensions() {
        return this.dimensions;
    }

    public String id() {
        return this.id;
    }

    public SegmentImportResource importDefinition() {
        return this.importDefinition;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String name() {
        return this.name;
    }

    public SegmentType segmentType() {
        return SegmentType.fromValue(this.segmentType);
    }

    public String segmentTypeString() {
        return this.segmentType;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentResponse)) {
            return false;
        }
        SegmentResponse other = (SegmentResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.importDefinition(), other.importDefinition()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.segmentTypeString(), other.segmentTypeString()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.importDefinition() != null) {
            sb.append("ImportDefinition: ").append(this.importDefinition()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.segmentTypeString() != null) {
            sb.append("SegmentType: ").append(this.segmentTypeString()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Dimensions": {
                return Optional.of(clazz.cast(this.dimensions()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "ImportDefinition": {
                return Optional.of(clazz.cast(this.importDefinition()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SegmentType": {
                return Optional.of(clazz.cast(this.segmentTypeString()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationDate;
        private SegmentDimensions dimensions;
        private String id;
        private SegmentImportResource importDefinition;
        private String lastModifiedDate;
        private String name;
        private String segmentType;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentResponse model) {
            this.applicationId(model.applicationId);
            this.creationDate(model.creationDate);
            this.dimensions(model.dimensions);
            this.id(model.id);
            this.importDefinition(model.importDefinition);
            this.lastModifiedDate(model.lastModifiedDate);
            this.name(model.name);
            this.segmentType(model.segmentType);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final SegmentDimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final SegmentImportResource.Builder getImportDefinition() {
            return this.importDefinition != null ? this.importDefinition.toBuilder() : null;
        }

        @Override
        public final Builder importDefinition(SegmentImportResource importDefinition) {
            this.importDefinition = importDefinition;
            return this;
        }

        public final void setImportDefinition(SegmentImportResource.BuilderImpl importDefinition) {
            this.importDefinition = importDefinition != null ? importDefinition.build() : null;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSegmentType() {
            return this.segmentType;
        }

        @Override
        public final Builder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        @Override
        public final Builder segmentType(SegmentType segmentType) {
            this.segmentType(segmentType.toString());
            return this;
        }

        public final void setSegmentType(String segmentType) {
            this.segmentType = segmentType;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public SegmentResponse build() {
            return new SegmentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentResponse> {
        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder dimensions(SegmentDimensions var1);

        default public Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return this.dimensions((SegmentDimensions)((SegmentDimensions.Builder)SegmentDimensions.builder().apply(dimensions)).build());
        }

        public Builder id(String var1);

        public Builder importDefinition(SegmentImportResource var1);

        default public Builder importDefinition(Consumer<SegmentImportResource.Builder> importDefinition) {
            return this.importDefinition((SegmentImportResource)((SegmentImportResource.Builder)SegmentImportResource.builder().apply(importDefinition)).build());
        }

        public Builder lastModifiedDate(String var1);

        public Builder name(String var1);

        public Builder segmentType(String var1);

        public Builder segmentType(SegmentType var1);

        public Builder version(Integer var1);
    }
}

