/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.SMSChannelRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SMSChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, SMSChannelRequest> {
    private final Boolean enabled;
    private final String senderId;
    private final String shortCode;

    private SMSChannelRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.senderId = builder.senderId;
        this.shortCode = builder.shortCode;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String senderId() {
        return this.senderId;
    }

    public String shortCode() {
        return this.shortCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSChannelRequest)) {
            return false;
        }
        SMSChannelRequest other = (SMSChannelRequest)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.senderId(), other.senderId()) && Objects.equals(this.shortCode(), other.shortCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.senderId() != null) {
            sb.append("SenderId: ").append(this.senderId()).append(",");
        }
        if (this.shortCode() != null) {
            sb.append("ShortCode: ").append(this.shortCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "SenderId": {
                return Optional.of(clazz.cast(this.senderId()));
            }
            case "ShortCode": {
                return Optional.of(clazz.cast(this.shortCode()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SMSChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String senderId;
        private String shortCode;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSChannelRequest model) {
            this.enabled(model.enabled);
            this.senderId(model.senderId);
            this.shortCode(model.shortCode);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public final String getShortCode() {
            return this.shortCode;
        }

        @Override
        public final Builder shortCode(String shortCode) {
            this.shortCode = shortCode;
            return this;
        }

        public final void setShortCode(String shortCode) {
            this.shortCode = shortCode;
        }

        public SMSChannelRequest build() {
            return new SMSChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SMSChannelRequest> {
        public Builder enabled(Boolean var1);

        public Builder senderId(String var1);

        public Builder shortCode(String var1);
    }
}

