/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteEventStream;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutEventStreamRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, PutEventStreamRequest> {
    private final String applicationId;
    private final WriteEventStream writeEventStream;

    private PutEventStreamRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeEventStream = builder.writeEventStream;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteEventStream writeEventStream() {
        return this.writeEventStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeEventStream());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventStreamRequest)) {
            return false;
        }
        PutEventStreamRequest other = (PutEventStreamRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.writeEventStream(), other.writeEventStream());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.writeEventStream() != null) {
            sb.append("WriteEventStream: ").append(this.writeEventStream()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "WriteEventStream": {
                return Optional.of(clazz.cast(this.writeEventStream()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteEventStream writeEventStream;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventStreamRequest model) {
            this.applicationId(model.applicationId);
            this.writeEventStream(model.writeEventStream);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteEventStream.Builder getWriteEventStream() {
            return this.writeEventStream != null ? this.writeEventStream.toBuilder() : null;
        }

        @Override
        public final Builder writeEventStream(WriteEventStream writeEventStream) {
            this.writeEventStream = writeEventStream;
            return this;
        }

        public final void setWriteEventStream(WriteEventStream.BuilderImpl writeEventStream) {
            this.writeEventStream = writeEventStream != null ? writeEventStream.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutEventStreamRequest build() {
            return new PutEventStreamRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, PutEventStreamRequest> {
        public Builder applicationId(String var1);

        public Builder writeEventStream(WriteEventStream var1);

        default public Builder writeEventStream(Consumer<WriteEventStream.Builder> writeEventStream) {
            return this.writeEventStream((WriteEventStream)((WriteEventStream.Builder)WriteEventStream.builder().apply(writeEventStream)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

