/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.MessageBodyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageBody
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageBody> {
    private final String message;
    private final String requestID;

    private MessageBody(BuilderImpl builder) {
        this.message = builder.message;
        this.requestID = builder.requestID;
    }

    public String message() {
        return this.message;
    }

    public String requestID() {
        return this.requestID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestID());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageBody)) {
            return false;
        }
        MessageBody other = (MessageBody)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.requestID(), other.requestID());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.requestID() != null) {
            sb.append("RequestID: ").append(this.requestID()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "RequestID": {
                return Optional.of(clazz.cast(this.requestID()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageBodyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String requestID;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageBody model) {
            this.message(model.message);
            this.requestID(model.requestID);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getRequestID() {
            return this.requestID;
        }

        @Override
        public final Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public final void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public MessageBody build() {
            return new MessageBody(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageBody> {
        public Builder message(String var1);

        public Builder requestID(String var1);
    }
}

