/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.CampaignEmailMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CampaignEmailMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignEmailMessage> {
    private final String body;
    private final String fromAddress;
    private final String htmlBody;
    private final String title;

    private CampaignEmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.fromAddress = builder.fromAddress;
        this.htmlBody = builder.htmlBody;
        this.title = builder.title;
    }

    public String body() {
        return this.body;
    }

    public String fromAddress() {
        return this.fromAddress;
    }

    public String htmlBody() {
        return this.htmlBody;
    }

    public String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.htmlBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignEmailMessage)) {
            return false;
        }
        CampaignEmailMessage other = (CampaignEmailMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.fromAddress(), other.fromAddress()) && Objects.equals(this.htmlBody(), other.htmlBody()) && Objects.equals(this.title(), other.title());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.fromAddress() != null) {
            sb.append("FromAddress: ").append(this.fromAddress()).append(",");
        }
        if (this.htmlBody() != null) {
            sb.append("HtmlBody: ").append(this.htmlBody()).append(",");
        }
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.of(clazz.cast(this.body()));
            }
            case "FromAddress": {
                return Optional.of(clazz.cast(this.fromAddress()));
            }
            case "HtmlBody": {
                return Optional.of(clazz.cast(this.htmlBody()));
            }
            case "Title": {
                return Optional.of(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignEmailMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String fromAddress;
        private String htmlBody;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignEmailMessage model) {
            this.body(model.body);
            this.fromAddress(model.fromAddress);
            this.htmlBody(model.htmlBody);
            this.title(model.title);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final String getHtmlBody() {
            return this.htmlBody;
        }

        @Override
        public final Builder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public final void setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public CampaignEmailMessage build() {
            return new CampaignEmailMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignEmailMessage> {
        public Builder body(String var1);

        public Builder fromAddress(String var1);

        public Builder htmlBody(String var1);

        public Builder title(String var1);
    }
}

