/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;

@SdkInternalApi
public class MessageConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> ADMMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ADMMessage").build();
    private static final MarshallingInfo<StructuredPojo> APNSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("APNSMessage").build();
    private static final MarshallingInfo<StructuredPojo> BAIDUMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaiduMessage").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultMessage").build();
    private static final MarshallingInfo<StructuredPojo> EMAILMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessage").build();
    private static final MarshallingInfo<StructuredPojo> GCMMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GCMMessage").build();
    private static final MarshallingInfo<StructuredPojo> SMSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SMSMessage").build();
    private static final MessageConfigurationMarshaller INSTANCE = new MessageConfigurationMarshaller();

    public static MessageConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MessageConfiguration messageConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (messageConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)messageConfiguration.admMessage(), ADMMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageConfiguration.apnsMessage(), APNSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageConfiguration.baiduMessage(), BAIDUMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageConfiguration.defaultMessage(), DEFAULTMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageConfiguration.emailMessage(), EMAILMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageConfiguration.gcmMessage(), GCMMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageConfiguration.smsMessage(), SMSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

