/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration;
import software.amazon.awssdk.services.pinpoint.transform.ADMMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.APNSMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.BaiduMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DefaultMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DefaultPushNotificationMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GCMMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SMSMessageUnmarshaller;

public class DirectMessageConfigurationUnmarshaller
implements Unmarshaller<DirectMessageConfiguration, JsonUnmarshallerContext> {
    private static final DirectMessageConfigurationUnmarshaller INSTANCE = new DirectMessageConfigurationUnmarshaller();

    public DirectMessageConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        DirectMessageConfiguration.Builder directMessageConfigurationBuilder = DirectMessageConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ADMMessage", targetDepth)) {
                    context.nextToken();
                    directMessageConfigurationBuilder.admMessage(ADMMessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("APNSMessage", targetDepth)) {
                    context.nextToken();
                    directMessageConfigurationBuilder.apnsMessage(APNSMessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("BaiduMessage", targetDepth)) {
                    context.nextToken();
                    directMessageConfigurationBuilder.baiduMessage(BaiduMessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DefaultMessage", targetDepth)) {
                    context.nextToken();
                    directMessageConfigurationBuilder.defaultMessage(DefaultMessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DefaultPushNotificationMessage", targetDepth)) {
                    context.nextToken();
                    directMessageConfigurationBuilder.defaultPushNotificationMessage(DefaultPushNotificationMessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("GCMMessage", targetDepth)) {
                    context.nextToken();
                    directMessageConfigurationBuilder.gcmMessage(GCMMessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SMSMessage", targetDepth)) {
                    context.nextToken();
                    directMessageConfigurationBuilder.smsMessage(SMSMessageUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DirectMessageConfiguration)directMessageConfigurationBuilder.build();
    }

    public static DirectMessageConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

