/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration;

@SdkInternalApi
public class DirectMessageConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> ADMMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ADMMessage").build();
    private static final MarshallingInfo<StructuredPojo> APNSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("APNSMessage").build();
    private static final MarshallingInfo<StructuredPojo> BAIDUMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaiduMessage").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultMessage").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTPUSHNOTIFICATIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultPushNotificationMessage").build();
    private static final MarshallingInfo<StructuredPojo> GCMMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GCMMessage").build();
    private static final MarshallingInfo<StructuredPojo> SMSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SMSMessage").build();
    private static final DirectMessageConfigurationMarshaller INSTANCE = new DirectMessageConfigurationMarshaller();

    public static DirectMessageConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DirectMessageConfiguration directMessageConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (directMessageConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)directMessageConfiguration.admMessage(), ADMMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)directMessageConfiguration.apnsMessage(), APNSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)directMessageConfiguration.baiduMessage(), BAIDUMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)directMessageConfiguration.defaultMessage(), DEFAULTMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)directMessageConfiguration.defaultPushNotificationMessage(), DEFAULTPUSHNOTIFICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)directMessageConfiguration.gcmMessage(), GCMMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)directMessageConfiguration.smsMessage(), SMSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

