/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.BaiduChannelRequest;

@SdkInternalApi
public class BaiduChannelRequestMarshaller {
    private static final MarshallingInfo<String> APIKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApiKey").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> SECRETKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretKey").build();
    private static final BaiduChannelRequestMarshaller INSTANCE = new BaiduChannelRequestMarshaller();

    public static BaiduChannelRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BaiduChannelRequest baiduChannelRequest, ProtocolMarshaller protocolMarshaller) {
        if (baiduChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)baiduChannelRequest.apiKey(), APIKEY_BINDING);
            protocolMarshaller.marshall((Object)baiduChannelRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)baiduChannelRequest.secretKey(), SECRETKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

