/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSmsChannelRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateSmsChannelRequest> {
    private final String applicationId;
    private final SMSChannelRequest smsChannelRequest;

    private UpdateSmsChannelRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.smsChannelRequest = builder.smsChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public SMSChannelRequest smsChannelRequest() {
        return this.smsChannelRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsChannelRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmsChannelRequest)) {
            return false;
        }
        UpdateSmsChannelRequest other = (UpdateSmsChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.smsChannelRequest(), other.smsChannelRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.smsChannelRequest() != null) {
            sb.append("SMSChannelRequest: ").append(this.smsChannelRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "SMSChannelRequest": {
                return Optional.of(clazz.cast(this.smsChannelRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private SMSChannelRequest smsChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmsChannelRequest model) {
            this.applicationId(model.applicationId);
            this.smsChannelRequest(model.smsChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final SMSChannelRequest.Builder getSMSChannelRequest() {
            return this.smsChannelRequest != null ? this.smsChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder smsChannelRequest(SMSChannelRequest smsChannelRequest) {
            this.smsChannelRequest = smsChannelRequest;
            return this;
        }

        public final void setSMSChannelRequest(SMSChannelRequest.BuilderImpl smsChannelRequest) {
            this.smsChannelRequest = smsChannelRequest != null ? smsChannelRequest.build() : null;
        }

        public UpdateSmsChannelRequest build() {
            return new UpdateSmsChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateSmsChannelRequest> {
        public Builder applicationId(String var1);

        public Builder smsChannelRequest(SMSChannelRequest var1);

        default public Builder smsChannelRequest(Consumer<SMSChannelRequest.Builder> smsChannelRequest) {
            return this.smsChannelRequest((SMSChannelRequest)((SMSChannelRequest.Builder)SMSChannelRequest.builder().apply(smsChannelRequest)).build());
        }
    }
}

