/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSegmentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateSegmentRequest> {
    private final String applicationId;
    private final String segmentId;
    private final WriteSegmentRequest writeSegmentRequest;

    private UpdateSegmentRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.segmentId = builder.segmentId;
        this.writeSegmentRequest = builder.writeSegmentRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public WriteSegmentRequest writeSegmentRequest() {
        return this.writeSegmentRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeSegmentRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSegmentRequest)) {
            return false;
        }
        UpdateSegmentRequest other = (UpdateSegmentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.writeSegmentRequest(), other.writeSegmentRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.segmentId() != null) {
            sb.append("SegmentId: ").append(this.segmentId()).append(",");
        }
        if (this.writeSegmentRequest() != null) {
            sb.append("WriteSegmentRequest: ").append(this.writeSegmentRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "SegmentId": {
                return Optional.of(clazz.cast(this.segmentId()));
            }
            case "WriteSegmentRequest": {
                return Optional.of(clazz.cast(this.writeSegmentRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String segmentId;
        private WriteSegmentRequest writeSegmentRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSegmentRequest model) {
            this.applicationId(model.applicationId);
            this.segmentId(model.segmentId);
            this.writeSegmentRequest(model.writeSegmentRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final WriteSegmentRequest.Builder getWriteSegmentRequest() {
            return this.writeSegmentRequest != null ? this.writeSegmentRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeSegmentRequest(WriteSegmentRequest writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest;
            return this;
        }

        public final void setWriteSegmentRequest(WriteSegmentRequest.BuilderImpl writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest != null ? writeSegmentRequest.build() : null;
        }

        public UpdateSegmentRequest build() {
            return new UpdateSegmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateSegmentRequest> {
        public Builder applicationId(String var1);

        public Builder segmentId(String var1);

        public Builder writeSegmentRequest(WriteSegmentRequest var1);

        default public Builder writeSegmentRequest(Consumer<WriteSegmentRequest.Builder> writeSegmentRequest) {
            return this.writeSegmentRequest((WriteSegmentRequest)((WriteSegmentRequest.Builder)WriteSegmentRequest.builder().apply(writeSegmentRequest)).build());
        }
    }
}

