/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.EndpointRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateEndpointRequest> {
    private final String applicationId;
    private final String endpointId;
    private final EndpointRequest endpointRequest;

    private UpdateEndpointRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.endpointId = builder.endpointId;
        this.endpointRequest = builder.endpointRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String endpointId() {
        return this.endpointId;
    }

    public EndpointRequest endpointRequest() {
        return this.endpointRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.endpointRequest(), other.endpointRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.endpointId() != null) {
            sb.append("EndpointId: ").append(this.endpointId()).append(",");
        }
        if (this.endpointRequest() != null) {
            sb.append("EndpointRequest: ").append(this.endpointRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "EndpointId": {
                return Optional.of(clazz.cast(this.endpointId()));
            }
            case "EndpointRequest": {
                return Optional.of(clazz.cast(this.endpointRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String endpointId;
        private EndpointRequest endpointRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            this.applicationId(model.applicationId);
            this.endpointId(model.endpointId);
            this.endpointRequest(model.endpointRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final EndpointRequest.Builder getEndpointRequest() {
            return this.endpointRequest != null ? this.endpointRequest.toBuilder() : null;
        }

        @Override
        public final Builder endpointRequest(EndpointRequest endpointRequest) {
            this.endpointRequest = endpointRequest;
            return this;
        }

        public final void setEndpointRequest(EndpointRequest.BuilderImpl endpointRequest) {
            this.endpointRequest = endpointRequest != null ? endpointRequest.build() : null;
        }

        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateEndpointRequest> {
        public Builder applicationId(String var1);

        public Builder endpointId(String var1);

        public Builder endpointRequest(EndpointRequest var1);

        default public Builder endpointRequest(Consumer<EndpointRequest.Builder> endpointRequest) {
            return this.endpointRequest((EndpointRequest)((EndpointRequest.Builder)EndpointRequest.builder().apply(endpointRequest)).build());
        }
    }
}

